/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.scalacommon;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class CenteredBoxStrategy
implements PhetPCanvas.TransformStrategy {
    private final double modelWidth;
    private final double modelHeight;
    private final JComponent canvas;
    private final double modelOffsetY;

    public AffineTransform getTransform() {
        AffineTransform affineTransform;
        if (this.canvas.getWidth() > 0 && this.canvas.getHeight() > 0) {
            ModelViewTransform2D mv2d = this.getModelViewTransform2D();
            affineTransform = mv2d.getAffineTransform();
        } else {
            affineTransform = new AffineTransform();
        }
        return affineTransform;
    }

    public double sx() {
        return (double)this.canvas.getWidth() / this.modelWidth;
    }

    public double sy() {
        return (double)this.canvas.getHeight() / this.modelHeight;
    }

    public double getScale() {
        double preferredScale = this.sx() < this.sy() ? this.sx() : this.sy();
        return preferredScale <= 0.0 ? 1.0 : preferredScale;
    }

    public ModelViewTransform2D getModelViewTransform2D() {
        double scale = this.getScale();
        scale = scale <= 0.0 ? this.sy() : scale;
        Rectangle2D.Double outputBox = scale == this.sx() ? new Rectangle2D.Double(0.0, (double)(this.canvas.getHeight() - this.canvas.getWidth()) / 2.0, this.canvas.getWidth(), this.canvas.getWidth()) : new Rectangle2D.Double((double)(this.canvas.getWidth() - this.canvas.getHeight()) / 2.0, 0.0, this.canvas.getHeight(), this.canvas.getHeight());
        return new ModelViewTransform2D(new Rectangle2D.Double(0.0, this.modelOffsetY, this.modelWidth, this.modelHeight), outputBox, false);
    }

    public CenteredBoxStrategy(double modelWidth, double modelHeight, JComponent canvas, double modelOffsetY) {
        this.modelWidth = modelWidth;
        this.modelHeight = modelHeight;
        this.canvas = canvas;
        this.modelOffsetY = modelOffsetY;
    }

    public CenteredBoxStrategy(double modelWidth, double modelHeight, JComponent canvas) {
        this(modelWidth, modelHeight, canvas, 0.0);
    }
}

