/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.ladybugmotion2d.aphidmaze;

import edu.colorado.phet.ladybugmotion2d.aphidmaze.MazeGenerator$;
import edu.colorado.phet.ladybugmotion2d.aphidmaze.Wall;
import java.util.Random;
import scala.Function1;
import scala.Math$;
import scala.Predef$;
import scala.Product;
import scala.Product$class;
import scala.Serializable;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashSet;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MazeGenerator {
    private final HashSet<Wall> walls = new HashSet();
    private final HashSet<Location> locations = new HashSet();
    private final int maxX;
    private final int maxY;
    private final Random random;
    private final ArrayBuffer<Location> stack;
    private Location current;
    private final HashSet<Location> visited;

    public HashSet<Wall> walls() {
        return this.walls;
    }

    public HashSet<Location> locations() {
        return this.locations;
    }

    public int maxX() {
        return this.maxX;
    }

    public int maxY() {
        return this.maxY;
    }

    public Random random() {
        return this.random;
    }

    public Range.Inclusive getXPoints() {
        return Predef$.MODULE$.intWrapper(-this.maxX()).to(this.maxX());
    }

    public Range.Inclusive getYPoints() {
        return Predef$.MODULE$.intWrapper(-this.maxY()).to(this.maxY());
    }

    public ArrayBuffer<Location> stack() {
        return this.stack;
    }

    public Location current() {
        return this.current;
    }

    public void current_$eq(Location location) {
        this.current = location;
    }

    public HashSet<Location> visited() {
        return this.visited;
    }

    public Wall getWallBetween(Location a, Location b) {
        int dx = Math$.MODULE$.abs(this.getXPoints().apply$mcII$sp(0) - this.getXPoints().apply$mcII$sp(1));
        int dy = Math$.MODULE$.abs(this.getYPoints().apply$mcII$sp(0) - this.getYPoints().apply$mcII$sp(1));
        return a.x() == b.x() ? new Wall(a.x(), Math$.MODULE$.max(a.y(), b.y()), dx, 0.0) : (a.y() == b.y() ? new Wall(Math$.MODULE$.max(a.x(), b.x()), a.y(), 0.0, dy) : new Wall(Math$.MODULE$.min(a.x(), b.x()), a.y(), Math$.MODULE$.min(a.x(), b.x()) + (double)dx, a.y()));
    }

    public HashSet<Location> getAdjacent(Location location$1) {
        int dx$2 = Math$.MODULE$.abs(this.getXPoints().apply$mcII$sp(0) - this.getXPoints().apply$mcII$sp(1));
        HashSet iterable = (HashSet)this.locations().filter((Function1<Location, Object>)((Object)new Serializable(this, location$1, dx$2){
            public static final long serialVersionUID;
            private final Location location$1;
            private final int dx$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Location location) {
                return location.distance(this.location$1) <= (double)this.dx$2 * 1.01;
            }
            {
                this.location$1 = location;
                this.dx$2 = n;
            }
        }));
        HashSet<Location> set = new HashSet<Location>();
        set.$plus$plus(iterable);
        return set;
    }

    public MazeGenerator(int dim) {
        this.maxX = dim;
        this.maxY = dim;
        this.random = new Random();
        this.getXPoints().foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final MazeGenerator $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int v1$1) {
                this.$outer.getYPoints().foreach(new Serializable(this, v1$1){
                    public static final long serialVersionUID;
                    private final $anonfun$1 $outer;
                    private final int v1$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final HashSet<Location> apply(int j) {
                        return this.$outer.edu$colorado$phet$ladybugmotion2d$aphidmaze$MazeGenerator$$anonfun$$$outer().locations().$plus$eq((Object)new Location(this.$outer.edu$colorado$phet$ladybugmotion2d$aphidmaze$MazeGenerator$$anonfun$$$outer(), this.v1$1, j));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.v1$1 = n;
                    }
                });
            }

            public MazeGenerator edu$colorado$phet$ladybugmotion2d$aphidmaze$MazeGenerator$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.locations().foreach(new Serializable(this){
            public static final long serialVersionUID;
            private final MazeGenerator $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Location a$1) {
                HashSet<Location> adjList = this.$outer.getAdjacent(a$1);
                adjList.foreach(new Serializable(this, a$1){
                    public static final long serialVersionUID;
                    private final $anonfun$3 $outer;
                    private final Location a$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final HashSet<Wall> apply(Location b) {
                        return this.$outer.edu$colorado$phet$ladybugmotion2d$aphidmaze$MazeGenerator$$anonfun$$$outer().walls().$plus$eq((Object)this.$outer.edu$colorado$phet$ladybugmotion2d$aphidmaze$MazeGenerator$$anonfun$$$outer().getWallBetween(this.a$1, b));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.a$1 = location;
                    }
                });
            }

            public MazeGenerator edu$colorado$phet$ladybugmotion2d$aphidmaze$MazeGenerator$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.stack = new ArrayBuffer();
        this.current = new Location(this, this.getXPoints().apply$mcII$sp(0), this.getYPoints().apply$mcII$sp(0));
        this.visited = new HashSet();
        while (true) {
            Object object;
            HashSet<Location> hashSet = this.visited();
            HashSet<Location> hashSet2 = this.locations();
            if (!(hashSet != null ? !((Object)hashSet).equals(hashSet2) : hashSet2 != null)) {
                this.getXPoints().foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(this){
                    public static final long serialVersionUID;
                    private final MazeGenerator $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int v1$2) {
                        this.$outer.getYPoints().foreach(new Serializable(this, v1$2){
                            public static final long serialVersionUID;
                            private final $anonfun$2 $outer;
                            private final int v1$2;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final Object apply(int j) {
                                Object object = this.v1$2 == this.$outer.edu$colorado$phet$ladybugmotion2d$aphidmaze$MazeGenerator$$anonfun$$$outer().getXPoints().apply$mcII$sp(0) ? this.$outer.edu$colorado$phet$ladybugmotion2d$aphidmaze$MazeGenerator$$anonfun$$$outer().walls().$plus$eq((Object)new Wall(this.v1$2, j, 0.0, 1.0)) : BoxedUnit.UNIT;
                                Object object2 = this.v1$2 == this.$outer.edu$colorado$phet$ladybugmotion2d$aphidmaze$MazeGenerator$$anonfun$$$outer().getXPoints().apply$mcII$sp(this.$outer.edu$colorado$phet$ladybugmotion2d$aphidmaze$MazeGenerator$$anonfun$$$outer().getXPoints().length() - 1) ? this.$outer.edu$colorado$phet$ladybugmotion2d$aphidmaze$MazeGenerator$$anonfun$$$outer().walls().$plus$eq((Object)new Wall(this.v1$2 + 1, j, 0.0, 1.0)) : BoxedUnit.UNIT;
                                Object object3 = j == this.$outer.edu$colorado$phet$ladybugmotion2d$aphidmaze$MazeGenerator$$anonfun$$$outer().getYPoints().apply$mcII$sp(0) ? this.$outer.edu$colorado$phet$ladybugmotion2d$aphidmaze$MazeGenerator$$anonfun$$$outer().walls().$plus$eq((Object)new Wall(this.v1$2, j, 1.0, 0.0)) : BoxedUnit.UNIT;
                                return j == this.$outer.edu$colorado$phet$ladybugmotion2d$aphidmaze$MazeGenerator$$anonfun$$$outer().getYPoints().apply$mcII$sp(this.$outer.edu$colorado$phet$ladybugmotion2d$aphidmaze$MazeGenerator$$anonfun$$$outer().getYPoints().length() - 1) ? this.$outer.edu$colorado$phet$ladybugmotion2d$aphidmaze$MazeGenerator$$anonfun$$$outer().walls().$plus$eq((Object)new Wall(this.v1$2, j + 1, 1.0, 0.0)) : BoxedUnit.UNIT;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.v1$2 = n;
                            }
                        });
                    }

                    public MazeGenerator edu$colorado$phet$ladybugmotion2d$aphidmaze$MazeGenerator$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
                return;
            }
            HashSet unvisitedNeighbors = (HashSet)this.getAdjacent(this.current()).$minus$minus(this.visited());
            if (unvisitedNeighbors.size() > 0) {
                Location chosenCell = (Location)unvisitedNeighbors.toSeq().apply(this.random().nextInt(unvisitedNeighbors.size()));
                this.walls().$minus$eq((Object)this.getWallBetween(this.current(), chosenCell));
                this.stack().$plus$eq((Object)this.current());
                this.current_$eq(chosenCell);
                object = this.visited().$plus$eq((Object)this.current());
                continue;
            }
            this.current_$eq(this.stack().remove(this.stack().length() - 1));
            object = BoxedUnit.UNIT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Location
    implements Product,
    Serializable {
        private final double x;
        private final double y;
        public final MazeGenerator $outer;

        public double x() {
            return this.x;
        }

        public double y() {
            return this.y;
        }

        public double distance(Location other) {
            return Math$.MODULE$.abs(this.x() - other.x()) + Math$.MODULE$.abs(this.y() - other.y());
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            double d;
            double y$2;
            if (this == object) return true;
            Object object2 = object;
            if (!(object2 instanceof Location)) return false;
            if (((Location)object2).edu$colorado$phet$ladybugmotion2d$aphidmaze$MazeGenerator$Location$$$outer() != this.edu$colorado$phet$ladybugmotion2d$aphidmaze$MazeGenerator$Location$$$outer()) return false;
            Location location = (Location)object2;
            double d2 = location.x();
            double x$3 = d2;
            if (!this.gd2$1(x$3, y$2 = (d = location.y()))) return false;
            boolean bl = ((Location)object).canEqual(this);
            if (!bl) return false;
            return true;
        }

        @Override
        public String productPrefix() {
            return "Location";
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public Object productElement(int n) {
            Double d;
            int n2 = n;
            switch (n2) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(n)).toString());
                }
                case 0: {
                    d = BoxesRunTime.boxToDouble(this.x());
                    break;
                }
                case 1: {
                    d = BoxesRunTime.boxToDouble(this.y());
                }
            }
            return d;
        }

        @Override
        public boolean canEqual(Object object) {
            return object instanceof Location;
        }

        public MazeGenerator edu$colorado$phet$ladybugmotion2d$aphidmaze$MazeGenerator$Location$$$outer() {
            return this.$outer;
        }

        private final boolean gd2$1(double d, double d2) {
            return d == this.x() && d2 == this.y();
        }

        public Location(MazeGenerator $outer, double x, double y) {
            this.x = x;
            this.y = y;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Product$class.$init$(this);
        }
    }
}

