/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.ladybugmotion2d;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.ladybugmotion2d.canvas.LadybugCanvas;
import edu.colorado.phet.ladybugmotion2d.controlpanel.LadybugControlPanel;
import edu.colorado.phet.ladybugmotion2d.controlpanel.PathVisibilityModel;
import edu.colorado.phet.ladybugmotion2d.controlpanel.VectorVisibilityModel;
import edu.colorado.phet.ladybugmotion2d.model.LadybugModel;
import edu.colorado.phet.ladybugmotion2d.model.LadybugMotionModel;
import edu.colorado.phet.ladybugmotion2d.model.LadybugState;
import edu.colorado.phet.recordandplayback.gui.PlaybackSpeedSlider;
import edu.colorado.phet.recordandplayback.gui.RecordAndPlaybackControlPanel;
import edu.colorado.phet.recordandplayback.model.RecordAndPlaybackModel;
import edu.colorado.phet.scalacommon.ScalaClock;
import edu.umd.cs.piccolo.PNode;
import scala.Function1;
import scala.Serializable;
import scala.runtime.BoxedUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LadybugModule<ModelType extends LadybugModel>
extends Module {
    public final Function1<LadybugModule<ModelType>, PNode> edu$colorado$phet$ladybugmotion2d$LadybugModule$$createRightControl;
    private final ModelType model;
    private final VectorVisibilityModel vectorVisibilityModel;
    private final PathVisibilityModel pathVisibilityModel;
    private final LadybugCanvas canvas;
    private final LadybugControlPanel<ModelType> controlPanel;

    public ModelType model() {
        return this.model;
    }

    public VectorVisibilityModel vectorVisibilityModel() {
        return this.vectorVisibilityModel;
    }

    public PathVisibilityModel pathVisibilityModel() {
        return this.pathVisibilityModel;
    }

    public LadybugCanvas canvas() {
        return this.canvas;
    }

    public LadybugControlPanel<ModelType> controlPanel() {
        return this.controlPanel;
    }

    public LadybugMotionModel getLadybugMotionModel() {
        return ((LadybugModel)this.model()).getLadybugMotionModel();
    }

    public void setLadybugDraggable(boolean draggable) {
        this.canvas().setLadybugDraggable(draggable);
    }

    public void resetAll() {
        ((LadybugModel)this.model()).resetAll();
        this.vectorVisibilityModel().resetAll();
        this.pathVisibilityModel().resetAll();
        this.controlPanel().resetAll();
    }

    public LadybugModule(String name, ScalaClock clock, ModelType _model, Function1<LadybugModule<ModelType>, LadybugCanvas> newCanvas, Function1<LadybugModule<ModelType>, LadybugControlPanel<ModelType>> newControlPanel, Function1<LadybugModule<ModelType>, PNode> createRightControl) {
        this.edu$colorado$phet$ladybugmotion2d$LadybugModule$$createRightControl = createRightControl;
        super(name, clock);
        this.model = _model;
        this.vectorVisibilityModel = new VectorVisibilityModel();
        this.pathVisibilityModel = new PathVisibilityModel();
        this.canvas = newCanvas.apply(this);
        this.controlPanel = newControlPanel.apply(this);
        this.setSimulationPanel(this.canvas());
        this.setControlPanel(this.controlPanel());
        clock.addClockListener((Function1<Object, BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final LadybugModule $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(double d) {
                this.apply$mcVD$sp(d);
            }

            public void apply$mcVD$sp(double v1) {
                ((RecordAndPlaybackModel)this.$outer.model()).stepInTime(v1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.setClockControlPanel(new RecordAndPlaybackControlPanel<LadybugState>(this){
            {
                this.addControl($outer.edu$colorado$phet$ladybugmotion2d$LadybugModule$$createRightControl.apply($outer));
            }
        });
    }

    public LadybugModule(ScalaClock clock) {
        this("ladybug-module", clock, new LadybugModel(), (Function1<LadybugModule<LadybugModel>, LadybugCanvas>)((Object)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final LadybugCanvas apply(LadybugModule<ModelType> m) {
                return new LadybugCanvas((LadybugModel)m.model(), m.vectorVisibilityModel(), m.pathVisibilityModel(), 20.0, 20.0);
            }
        }), (Function1<LadybugModule<LadybugModel>, LadybugControlPanel<LadybugModel>>)((Object)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final LadybugControlPanel<ModelType> apply(LadybugModule<ModelType> m) {
                return new LadybugControlPanel<ModelType>(m);
            }
        }), (Function1<LadybugModule<LadybugModel>, PNode>)((Object)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final PlaybackSpeedSlider<LadybugState> apply(LadybugModule<ModelType> m) {
                return new PlaybackSpeedSlider<LadybugState>((RecordAndPlaybackModel<LadybugState>)m.model());
            }
        }));
    }
}

