/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.matrices;

import JSci.maths.ArrayMath;
import JSci.maths.matrices.AbstractDoubleMatrix;
import JSci.maths.matrices.AbstractDoubleSquareMatrix;
import JSci.maths.matrices.Matrix;
import JSci.maths.matrices.MatrixDimensionException;

public class DoubleSquareMatrix
extends AbstractDoubleSquareMatrix {
    protected final double[][] matrix;

    public DoubleSquareMatrix(double[][] dArray) {
        super(dArray.length);
        if (!ArrayMath.isSquare(dArray)) {
            throw new MatrixDimensionException("Array is not square.");
        }
        this.matrix = dArray;
    }

    public DoubleSquareMatrix(int n) {
        this(new double[n][n]);
    }

    public boolean equals(AbstractDoubleMatrix abstractDoubleMatrix, double d) {
        if (abstractDoubleMatrix != null && this.numRows == abstractDoubleMatrix.rows() && this.numCols == abstractDoubleMatrix.columns()) {
            double d2 = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    double d3 = this.matrix[i][j] - abstractDoubleMatrix.getElement(i, j);
                    d2 += d3 * d3;
                }
            }
            return d2 <= d * d;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                stringBuffer.append(this.matrix[i][j]);
                stringBuffer.append(' ');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public double getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            return this.matrix[n][n2];
        }
        throw new MatrixDimensionException(Matrix.getInvalidElementMsg(n, n2));
    }

    public double infNorm() {
        double d = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < this.numCols; ++j) {
                d2 += Math.abs(this.matrix[i][j]);
            }
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public AbstractDoubleSquareMatrix[] choleskyDecompose() {
        int n;
        double d;
        int n2 = this.numRows;
        double[][] dArray = new double[n2][n2];
        double[][] dArray2 = new double[n2][n2];
        double d2 = d = Math.sqrt(this.matrix[0][0]);
        dArray2[0][0] = d2;
        dArray[0][0] = d2;
        for (n = 1; n < n2; ++n) {
            double d3 = this.matrix[n][0] / d;
            dArray2[0][n] = d3;
            dArray[n][0] = d3;
        }
        for (n = 1; n < n2; ++n) {
            int n3;
            d = this.matrix[n][n];
            for (n3 = 0; n3 < n; ++n3) {
                d -= dArray[n][n3] * dArray[n][n3];
            }
            double d4 = Math.sqrt(d);
            dArray2[n][n] = d4;
            dArray[n][n] = d4;
            for (n3 = n + 1; n3 < n2; ++n3) {
                d = this.matrix[n3][n];
                for (int i = 0; i < n3; ++i) {
                    d -= dArray[n][i] * dArray2[i][n3];
                }
                double d5 = d / dArray2[n][n];
                dArray2[n][n3] = d5;
                dArray[n3][n] = d5;
            }
        }
        AbstractDoubleSquareMatrix[] abstractDoubleSquareMatrixArray = new AbstractDoubleSquareMatrix[]{new DoubleSquareMatrix(dArray), new DoubleSquareMatrix(dArray2)};
        return abstractDoubleSquareMatrixArray;
    }
}

