/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetgraphics.view;

import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsSetup;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsState;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;

public class ApparatusPanel
extends JPanel {
    private BasicStroke borderStroke = new BasicStroke(1.0f, 1, 1);
    private GraphicLayerSet graphic;
    private ArrayList graphicsSetups = new ArrayList();
    private boolean displayBorder = true;

    public ApparatusPanel() {
        super(null);
        this.setGraphic(new GraphicLayerSet(this));
        this.setMouseAndKeyListeners(this.getGraphic().getMouseHandler(), this.getGraphic().getKeyAdapter());
    }

    public void setGraphic(GraphicLayerSet graphicLayerSet) {
        this.graphic = graphicLayerSet;
        this.graphic.setComponent(this);
        Iterator iterator = this.graphic.getGraphicMap().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof PhetGraphic)) continue;
            PhetGraphic phetGraphic = (PhetGraphic)e;
            phetGraphic.setComponent(this);
        }
    }

    protected void setMouseAndKeyListeners(MouseInputListener mouseInputListener, KeyListener keyListener) {
        MouseListener[] mouseListenerArray = this.getMouseListeners();
        for (int i = 0; i < mouseListenerArray.length; ++i) {
            MouseListener mouseListener = mouseListenerArray[i];
            this.removeMouseListener(mouseListener);
        }
        MouseMotionListener[] mouseMotionListenerArray = this.getMouseMotionListeners();
        for (int i = 0; i < mouseMotionListenerArray.length; ++i) {
            MouseMotionListener mouseMotionListener = mouseMotionListenerArray[i];
            this.removeMouseMotionListener(mouseMotionListener);
        }
        KeyListener[] keyListenerArray = this.getKeyListeners();
        for (int i = 0; i < keyListenerArray.length; ++i) {
            KeyListener keyListener2 = keyListenerArray[i];
            this.removeKeyListener(keyListener2);
        }
        this.addMouseListener(mouseInputListener);
        this.addMouseMotionListener(this.getGraphic().getMouseHandler());
        this.addKeyListener(keyListener);
    }

    protected void setup(Graphics2D graphics2D) {
        for (int i = 0; i < this.graphicsSetups.size(); ++i) {
            GraphicsSetup graphicsSetup = (GraphicsSetup)this.graphicsSetups.get(i);
            graphicsSetup.setup(graphics2D);
        }
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paintComponent(graphics2D);
        GraphicsState graphicsState = new GraphicsState(graphics2D);
        this.setup(graphics2D);
        this.graphic.paint(graphics2D);
        this.drawBorder(graphics2D);
        graphicsState.restoreGraphics();
    }

    protected void doPaintSuper(Graphics graphics) {
        super.paintComponent(graphics);
    }

    public void paint() {
        this.repaint();
    }

    public GraphicLayerSet getGraphic() {
        return this.graphic;
    }

    protected void drawBorder(Graphics2D graphics2D) {
        if (this.displayBorder) {
            GraphicsState graphicsState = new GraphicsState(graphics2D);
            graphics2D.setColor(Color.black);
            graphics2D.setStroke(this.borderStroke);
            Rectangle rectangle = new Rectangle(0, 0, (int)this.getBounds().getWidth() - 1, (int)this.getBounds().getHeight() - 1);
            graphics2D.draw(rectangle);
            graphicsState.restoreGraphics();
        }
    }
}

