/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;

public class PText
extends PNode {
    public static Font DEFAULT_FONT = new Font("SansSerif", 0, 12);
    public static double DEFAULT_GREEK_THRESHOLD = 5.5;
    public static final Paint DEFAULT_TEXT_PAINT = Color.BLACK;
    private static final TextLayout[] EMPTY_TEXT_LAYOUT_ARRAY = new TextLayout[0];
    private String text = "";
    private Paint textPaint = DEFAULT_TEXT_PAINT;
    private Font font = DEFAULT_FONT;
    protected double greekThreshold = DEFAULT_GREEK_THRESHOLD;
    private float horizontalAlignment = 0.0f;
    private boolean constrainHeightToTextHeight = true;
    private boolean constrainWidthToTextWidth = true;
    private transient TextLayout[] lines;

    public PText() {
        this.setText("");
    }

    public PText(String string) {
        this();
        this.setText(string);
    }

    public void setJustification(float f) {
        this.setHorizontalAlignment(f);
    }

    public void setHorizontalAlignment(float f) {
        if (!PText.validHorizontalAlignment(f)) {
            throw new IllegalArgumentException("horizontalAlignment must be one of Component.LEFT_ALIGNMENT, Component.CENTER_ALIGNMENT, or Component.RIGHT_ALIGNMENT");
        }
        this.horizontalAlignment = f;
    }

    private static boolean validHorizontalAlignment(float f) {
        return 0.0f == f || 0.5f == f || 1.0f == f;
    }

    public void setTextPaint(Paint paint) {
        if (paint == this.textPaint) {
            return;
        }
        Paint paint2 = this.textPaint;
        this.textPaint = paint;
        this.invalidatePaint();
        this.firePropertyChange(0x200000, "text  paint", paint2, this.textPaint);
    }

    public void setText(String string) {
        if (string == null && this.text == null || string != null && string.equals(this.text)) {
            return;
        }
        String string2 = this.text;
        this.text = string == null ? "" : string;
        this.lines = null;
        this.recomputeLayout();
        this.invalidatePaint();
        this.firePropertyChange(524288, "text", string2, this.text);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == this.font) {
            return;
        }
        Font font2 = this.font;
        this.font = font == null ? DEFAULT_FONT : font;
        this.lines = null;
        this.recomputeLayout();
        this.invalidatePaint();
        this.firePropertyChange(0x100000, "font", font2, this.font);
    }

    public void recomputeLayout() {
        ArrayList<TextLayout> arrayList = new ArrayList<TextLayout>();
        double d = 0.0;
        double d2 = 0.0;
        if (this.text != null && this.text.length() > 0) {
            AttributedString attributedString = new AttributedString(this.text);
            attributedString.addAttribute(TextAttribute.FONT, this.getFont());
            AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, PPaintContext.RENDER_QUALITY_HIGH_FRC);
            float f = this.constrainWidthToTextWidth ? Float.MAX_VALUE : (float)this.getWidth();
            int n = this.text.indexOf(10);
            n = n == -1 ? Integer.MAX_VALUE : ++n;
            while (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex()) {
                TextLayout textLayout = this.computeNextLayout(lineBreakMeasurer, f, n);
                if (n == lineBreakMeasurer.getPosition()) {
                    n = this.text.indexOf(10, lineBreakMeasurer.getPosition());
                    n = n == -1 ? Integer.MAX_VALUE : ++n;
                }
                arrayList.add(textLayout);
                d2 += (double)textLayout.getAscent();
                d2 += (double)(textLayout.getDescent() + textLayout.getLeading());
                d = Math.max(d, (double)textLayout.getAdvance());
            }
        }
        this.lines = arrayList.toArray(EMPTY_TEXT_LAYOUT_ARRAY);
        if (this.constrainWidthToTextWidth || this.constrainHeightToTextHeight) {
            double d3 = this.getWidth();
            double d4 = this.getHeight();
            if (this.constrainWidthToTextWidth) {
                d3 = d;
            }
            if (this.constrainHeightToTextHeight) {
                d4 = d2;
            }
            super.setBounds(this.getX(), this.getY(), d3, d4);
        }
    }

    protected TextLayout computeNextLayout(LineBreakMeasurer lineBreakMeasurer, float f, int n) {
        return lineBreakMeasurer.nextLayout(f, n, false);
    }

    protected void paintGreek(PPaintContext pPaintContext) {
    }

    protected void paintText(PPaintContext pPaintContext) {
        float f = (float)this.getX();
        float f2 = (float)this.getY();
        float f3 = (float)this.getHeight() + f2;
        Graphics2D graphics2D = pPaintContext.getGraphics();
        if (this.lines == null) {
            this.recomputeLayout();
            this.repaint();
            return;
        }
        graphics2D.setPaint(this.textPaint);
        for (int i = 0; i < this.lines.length; ++i) {
            TextLayout textLayout = this.lines[i];
            if (f3 < (f2 += textLayout.getAscent())) {
                return;
            }
            float f4 = (float)(this.getWidth() - (double)textLayout.getAdvance()) * this.horizontalAlignment;
            textLayout.draw(graphics2D, f + f4, f2);
            f2 += textLayout.getDescent() + textLayout.getLeading();
        }
    }

    protected void paint(PPaintContext pPaintContext) {
        super.paint(pPaintContext);
        if (this.textPaint == null) {
            return;
        }
        float f = (float)this.getFont().getSize() * (float)pPaintContext.getScale();
        if ((double)f <= this.greekThreshold) {
            this.paintGreek(pPaintContext);
        }
        this.paintText(pPaintContext);
    }

    protected void internalUpdateBounds(double d, double d2, double d3, double d4) {
        this.recomputeLayout();
    }
}

