/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.mri.MriConfig;
import edu.colorado.phet.mri.model.PlaneWaveMedium;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;

public class PlaneWaveGraphic
extends PNode
implements SimpleObserver,
PlaneWaveMedium.Listener {
    private static Map maxColorToShades = new HashMap();
    public static boolean Y_GRADIENT = false;
    private PlaneWaveMedium waveMedium;
    private double maxOpacity;
    private Point2D origin;
    private double width;
    private float opacity = 1.0f;
    private double xExtent;
    private Paint[] colorForAmplitude = new Paint[255];
    private PPath[] components;
    private double stepSize;

    public PlaneWaveGraphic(PlaneWaveMedium planeWaveMedium, double d, Color color) {
        this.waveMedium = planeWaveMedium;
        this.maxOpacity = d;
        planeWaveMedium.addObserver(this);
        this.stepSize = planeWaveMedium.getSpeed();
        this.colorForAmplitude = (Paint[])maxColorToShades.get(color);
        if (this.colorForAmplitude == null) {
            this.colorForAmplitude = this.computePaintArray(color);
            maxColorToShades.put(color, this.colorForAmplitude);
        }
        this.origin = planeWaveMedium.getOrigin();
        this.xExtent = planeWaveMedium.getLongitudinalExtent();
        this.width = planeWaveMedium.getLateralExtent();
        this.stepSize = planeWaveMedium.getSpeed();
        int n = (int)(this.xExtent / this.stepSize);
        this.components = new PPath[n];
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.stepSize;
        double d5 = this.stepSize;
        double d6 = 0.0;
        double d7 = 0.0;
        if (planeWaveMedium.getDirection() == PlaneWaveMedium.EAST) {
            d2 = this.stepSize;
            d5 = this.width * MriConfig.SCALE_FOR_ORG;
            d7 = 0.5;
        } else if (planeWaveMedium.getDirection() == PlaneWaveMedium.WEST) {
            d2 = -this.stepSize;
            d5 = this.width;
            d7 = 0.5;
        } else if (planeWaveMedium.getDirection() == PlaneWaveMedium.NORTH) {
            d3 = -this.stepSize;
            d4 = this.width;
            d6 = 0.5;
        } else if (planeWaveMedium.getDirection() == PlaneWaveMedium.SOUTH) {
            d3 = this.stepSize;
            d4 = this.width;
            d7 = 0.5;
        }
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i] = new PPath(new Rectangle2D.Double(this.origin.getX() + (double)i * d2 - d6 * this.width, this.origin.getY() + (double)i * d3 - d7 * this.width, d4, d5));
            this.components[i].setStrokePaint(null);
            this.addChild(this.components[i]);
        }
        this.computePaintArray(color);
    }

    public Paint[] computePaintArray(Color color) {
        int n = 255;
        Paint[] paintArray = new Paint[n];
        for (int i = 0; i < paintArray.length; ++i) {
            paintArray[i] = Y_GRADIENT ? new GradientPaint(0.0f, (int)(this.origin.getY() - this.width / 2.0), new Color(color.getRed(), color.getGreen(), color.getBlue(), 0), 0.0f, (int)this.origin.getY(), new Color(color.getRed(), color.getGreen(), color.getBlue(), i), true) : new Color(color.getRed(), color.getGreen(), color.getBlue(), i);
        }
        return paintArray;
    }

    private Paint getColorForAmplitude(double d) {
        double d2 = Math.min(1.0, Math.abs(this.maxOpacity * d / 100.0));
        return this.colorForAmplitude[(int)(d2 * 254.0)];
    }

    public void update() {
        for (int i = this.components.length - 1; i > 0; --i) {
            Paint paint = this.getColorForAmplitude(this.waveMedium.getAmplitudeAt((double)i * this.stepSize));
            this.components[i].setPaint(paint);
        }
    }

    public void leftSystem(PlaneWaveMedium planeWaveMedium) {
    }
}

