/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.view;

import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.mri.MriResources;
import edu.colorado.phet.mri.util.ControlBorderFactory;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MriLegend
extends JPanel {
    public MriLegend() {
        super(new GridBagLayout());
        this.setBorder(ControlBorderFactory.createPrimaryBorder(MriResources.getString("ControlPanel.Legend")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0);
        BufferedImage bufferedImage = MriResources.getImage("dipole-5-hydrogen.gif");
        bufferedImage = BufferedImageUtils.getRotatedImage(bufferedImage, 1.5707963267948966);
        ImageIcon imageIcon = new ImageIcon(bufferedImage);
        double d = 25.0;
        double d2 = 1.0;
        Arrow arrow = new Arrow(new Point2D.Double(0.0, d * d2 / 2.0), new Point2D.Double(0.0, d * -d2 / 2.0), d / 2.0, d / 2.0, d / 4.0, 0.5, true);
        Area area = new Area(arrow.getShape());
        BufferedImage bufferedImage2 = new BufferedImage((int)area.getBounds().getWidth(), (int)area.getBounds().getHeight() + 2, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
        graphics2D.translate(bufferedImage2.getWidth() / 2, bufferedImage2.getHeight() / 2);
        graphics2D.setColor(Color.black);
        graphics2D.draw(area);
        graphics2D.dispose();
        ImageIcon imageIcon2 = new ImageIcon(bufferedImage2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 10;
        this.add((Component)new JLabel(MriResources.getString("NMR.abbreviation")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)new JLabel(MriResources.getString("NMR.definition")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 10;
        this.add((Component)new JLabel(MriResources.getString("MRI.abbreviation")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)new JLabel(MriResources.getString("MRI.definition")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 10;
        this.add((Component)new JLabel(imageIcon), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)new JLabel(MriResources.getString("ControlPanel.Atom")), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 10;
        this.add((Component)new JLabel(imageIcon2), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)new JLabel(MriResources.getString("ControlPanel.Legend.MagneticField")), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 10;
        JLabel jLabel = new JLabel(new ImageIcon(this.getWaveLegendItemImage()));
        jLabel.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)new JLabel(MriResources.getString("ControlPanel.Legend.RadioWave")), gridBagConstraints);
    }

    private BufferedImage getWaveLegendItemImage() {
        BufferedImage bufferedImage = MriResources.getImage("wavetop2.gif");
        BufferedImage bufferedImage2 = MriResources.getImage("photon2.gif");
        PCanvas pCanvas = new PCanvas();
        pCanvas.setBackground(new Color(0, 0, 0, 0));
        PImage pImage = new PImage(bufferedImage);
        pCanvas.getLayer().addChild(pImage);
        PText pText = new PText(MriResources.getString("ControlPanel.Legend.or"));
        pCanvas.getLayer().addChild(pText);
        pText.setOffset(pImage.getFullBounds().getCenterX() - pText.getFullBounds().getWidth() / 2.0, pImage.getFullBounds().getMaxY());
        PImage pImage2 = new PImage(bufferedImage2);
        pCanvas.getLayer().addChild(pImage2);
        pImage2.setOffset(pImage.getFullBounds().getCenterX() - pImage2.getFullBounds().getWidth() / 2.0, pText.getFullBounds().getMaxY());
        pCanvas.setSize(Math.max(bufferedImage.getWidth(), bufferedImage2.getWidth()), (int)Math.max(pImage2.getFullBounds().getMaxY(), pText.getFullBounds().getMaxY()));
        BufferedImage bufferedImage3 = new BufferedImage(pCanvas.getWidth(), pCanvas.getHeight(), 3);
        Graphics2D graphics2D = bufferedImage3.createGraphics();
        pCanvas.paintComponent(graphics2D);
        graphics2D.dispose();
        return bufferedImage3;
    }
}

