/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.view;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.quantum.QuantumConfig;
import edu.colorado.phet.common.quantum.model.PhotonSource;
import edu.colorado.phet.mri.MriConfig;
import edu.colorado.phet.mri.MriResources;
import edu.colorado.phet.mri.model.Dipole;
import edu.colorado.phet.mri.model.Electromagnet;
import edu.colorado.phet.mri.model.MriModel;
import edu.colorado.phet.mri.model.SampleMaterial;
import edu.colorado.phet.mri.model.Spin;
import edu.colorado.phet.mri.view.DipoleGraphic;
import edu.colorado.phet.mri.view.EnergySquiggle;
import edu.colorado.phet.mri.view.EnergySquiggleUpdater;
import edu.colorado.phet.mri.view.SampleChamberGraphic;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;

public class MonitorPanel
extends PhetPCanvas {
    private BufferedImage upperDipoleImage;
    private BufferedImage lowerDipoleImage;
    private double imageWidth;
    private double scale = 0.4;
    private double SQUIGGLE_LENGTH_CALIBRATION_FACTOR = 2.9645E8;
    private ArrayList spinUpReps = new ArrayList();
    private ArrayList spinDownReps = new ArrayList();
    private EnergyLevel lowerLine;
    private EnergyLevel upperLine;
    private double fieldStrength;
    private EnergySquiggle energySquiggle;
    private double energySquiggleReserveX = 15.0;
    private double energyAxisReserveX = 30.0;
    private double heightFractionUsed = 0.85;
    private boolean matched = false;
    private DipoleRepresentationPolicy dipoleRepresentationPolicy = MriConfig.InitialConditions.MONITOR_PANEL_REP_POLICY_DIPOLE;
    private EnergySquiggleUpdater energySquiggleUpdater;
    private MriModel model;

    public MonitorPanel(MriModel mriModel) {
        this.model = mriModel;
        this.setBackground(SampleChamberGraphic.BACKGROUND);
        this.makeImages(this.scale, mriModel.getSampleMaterial());
        this.lowerLine = new EnergyLevel(200.0, this.spinDownReps, this.lowerDipoleImage);
        this.addWorldChild(this.lowerLine);
        this.lowerLine.setOffset(0.0, 100.0);
        this.upperLine = new EnergyLevel(200.0, this.spinUpReps, this.upperDipoleImage);
        this.addWorldChild(this.upperLine);
        this.upperLine.setOffset(0.0, 60.0);
        this.energySquiggle = new EnergySquiggle(EnergySquiggle.VERTICAL);
        this.addWorldChild(this.energySquiggle);
        this.energySquiggle.setOffset(this.energyAxisReserveX, 0.0);
        this.energySquiggleUpdater = new EnergySquiggleUpdater(this.energySquiggle, mriModel);
        EnergyAxis energyAxis = new EnergyAxis();
        energyAxis.setOffset(5.0, 50.0);
        this.addWorldChild(energyAxis);
        mriModel.addListener(new ModelChangeListener());
        mriModel.addModelElement(new DipoleRepUpdater());
        mriModel.getLowerMagnet().addChangeListener(new EnergyLevelSeparationUpdater());
        SquiggleUpdater squiggleUpdater = new SquiggleUpdater();
        mriModel.getRadiowaveSource().addWavelengthChangeListener(squiggleUpdater);
        mriModel.getRadiowaveSource().addRateChangeListener(squiggleUpdater);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                MonitorPanel.this.updatePanel();
            }
        });
        this.updatePanel();
        mriModel.getRadiowaveSource().addWavelengthChangeListener(new PhotonSource.WavelengthChangeListener(){

            public void wavelengthChanged(PhotonSource.WavelengthChangeEvent wavelengthChangeEvent) {
                MonitorPanel.this.updateLineFlash();
            }
        });
        mriModel.getRadiowaveSource().addRateChangeListener(new PhotonSource.RateChangeListener(){

            public void rateChangeOccurred(PhotonSource.RateChangeEvent rateChangeEvent) {
                MonitorPanel.this.updateLineFlash();
            }
        });
    }

    private void updatePanel() {
        this.setLinePositions(this.model);
        this.updateSquiggle();
        this.updateLineFlash();
    }

    private void updateLineFlash() {
        this.upperLine.setFlashing(this.model.isTransitionMatch());
    }

    private void setLinePositions(MriModel mriModel) {
        double d = this.lowerDipoleImage.getHeight() / 2;
        double d2 = (double)(this.getHeight() / 2) * this.heightFractionUsed - d;
        double d3 = Math.min(this.fieldStrength / 3.0, 1.0);
        double d4 = mriModel.getSampleMaterial().getMu() / SampleMaterial.HYDROGEN.getMu();
        double d5 = d2 * d3 * d4;
        double d6 = (double)(this.getHeight() / 2) + d;
        this.lowerLine.setPositionY(d6 + d5);
        this.upperLine.setPositionY(d6 - d5);
    }

    private void adjustSquiggle() {
        this.updateSquiggle();
    }

    private void updateSquiggle() {
        this.energySquiggleUpdater.updateSquiggle(this.energySquiggle.getOffset().getX(), this.lowerLine.getOffset().getY(), this.SQUIGGLE_LENGTH_CALIBRATION_FACTOR);
    }

    private void makeImages(double d, SampleMaterial sampleMaterial) {
        this.lowerDipoleImage = DipoleGraphic.getDipoleImage(sampleMaterial);
        this.upperDipoleImage = DipoleGraphic.getDipoleImage(sampleMaterial);
        this.lowerDipoleImage = BufferedImageUtils.getRotatedImage(this.lowerDipoleImage, 1.5707963267948966);
        this.upperDipoleImage = BufferedImageUtils.getRotatedImage(this.upperDipoleImage, -1.5707963267948966);
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 2);
        this.lowerDipoleImage = affineTransformOp.filter(this.lowerDipoleImage, null);
        this.upperDipoleImage = affineTransformOp.filter(this.upperDipoleImage, null);
        this.imageWidth = Math.max(this.lowerDipoleImage.getWidth(), this.upperDipoleImage.getWidth());
    }

    private class DipoleRepUpdater
    implements ModelElement {
        private DipoleRepUpdater() {
        }

        public void stepInTime(double d) {
            List list = MonitorPanel.this.model.getDipoles();
            MonitorPanel.this.dipoleRepresentationPolicy.representSpins(list, MonitorPanel.this.spinUpReps, MonitorPanel.this.spinDownReps);
        }
    }

    public static interface DipoleRepresentationPolicy {
        public void representSpins(List var1, List var2, List var3);
    }

    public static class DiscretePolicy
    implements DipoleRepresentationPolicy {
        public void representSpins(List list, List list2, List list3) {
            for (int i = 0; i < list.size(); ++i) {
                Dipole dipole = (Dipole)list.get(i);
                boolean bl = dipole.getSpin() == Spin.UP;
                boolean bl2 = !bl;
                ((PNode)list2.get(i)).setVisible(bl);
                ((PNode)list3.get(i)).setVisible(bl2);
            }
        }
    }

    private class EnergyAxis
    extends PNode {
        public EnergyAxis() {
            PText pText = new PText(MriResources.getString("Misc.Energy"));
            pText.rotate(-1.5707963267948966);
            this.addChild(pText);
            Arrow arrow = new Arrow(new Point2D.Double(10.0, 40.0), new Point2D.Double(10.0, 0.0), 10.0, 8.0, 3.0, 1.0, false);
            PPath pPath = new PPath(arrow.getShape());
            pPath.setPaint(new Color(80, 80, 80));
            this.addChild(pPath);
            pPath.setOffset(10.0, -40.0);
        }
    }

    private class EnergyLevel
    extends PNode {
        private PPath lineNode;
        private List nucleiReps;
        private BufferedImage dipoleRepImage;
        private Line2D line;
        private Timer flashingTimer;
        private long flashingTimerStartTime = 0L;

        public EnergyLevel(double d, List list, BufferedImage bufferedImage) {
            this.nucleiReps = list;
            this.dipoleRepImage = bufferedImage;
            this.line = new Line2D.Double(0.0, 0.0, d, 0.0);
            this.lineNode = new PPath(this.line);
            this.lineNode.setStroke(new BasicStroke(3.0f));
            this.addChild(this.lineNode);
            MonitorPanel.this.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    EnergyLevel.this.setLinelength(componentEvent.getComponent().getWidth());
                }
            });
            for (int i = 0; i < MonitorPanel.this.model.getDipoles().size(); ++i) {
                this.addDipoleRep();
            }
            MonitorPanel.this.model.addListener(new MriModel.ChangeAdapter(){

                public void modelElementAdded(ModelElement modelElement) {
                    if (modelElement instanceof Dipole) {
                        EnergyLevel.this.addDipoleRep();
                    }
                }
            });
            this.flashingTimer = new Timer(100, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    EnergyLevel.this.setPaint(EnergyLevel.this.lineNode.getStrokePaint() == QuantumConfig.BLINK_LINE_COLOR ? Color.black : QuantumConfig.BLINK_LINE_COLOR);
                    if (System.currentTimeMillis() - EnergyLevel.this.flashingTimerStartTime >= 750L) {
                        EnergyLevel.this.setFlashing(false);
                    }
                }
            });
            this.flashingTimer.setInitialDelay(100);
        }

        public void setPaint(Paint paint) {
            if (this.lineNode.getStrokePaint() != paint) {
                this.lineNode.setStrokePaint(paint);
                MonitorPanel.this.paintImmediately(this.lineNode.getGlobalFullBounds().getBounds());
            }
        }

        public void setDipoleRepImage(BufferedImage bufferedImage) {
            this.dipoleRepImage = bufferedImage;
            for (PImage pImage : this.nucleiReps) {
                pImage.setImage(bufferedImage);
            }
        }

        private void setLinelength(double d) {
            this.line.setLine(this.line.getX1(), this.line.getY1(), this.line.getX1() + d, this.line.getY2());
            this.lineNode.setPathTo(this.line);
        }

        private void addDipoleRep() {
            PImage pImage = new PImage(this.dipoleRepImage);
            this.nucleiReps.add(pImage);
            pImage.setOffset((double)(this.nucleiReps.size() - 1) * MonitorPanel.this.imageWidth + MonitorPanel.this.energySquiggleReserveX + MonitorPanel.this.energyAxisReserveX, -pImage.getHeight());
            this.addChild(pImage);
            MonitorPanel.this.setPreferredSize(new Dimension((int)((double)(this.dipoleRepImage.getWidth() * (this.nucleiReps.size() + 1)) + MonitorPanel.this.energySquiggleReserveX + MonitorPanel.this.energyAxisReserveX), MonitorPanel.this.getPreferredSize().height));
        }

        public void setPositionY(double d) {
            this.setOffset(0.0, d);
        }

        public void setFlashing(boolean bl) {
            this.setPaint(bl ? QuantumConfig.BLINK_LINE_COLOR : Color.black);
            if (bl) {
                this.flashingTimer.start();
                this.flashingTimerStartTime = System.currentTimeMillis();
            } else {
                this.flashingTimer.stop();
            }
        }
    }

    private class EnergyLevelSeparationUpdater
    implements Electromagnet.ChangeListener {
        private EnergyLevelSeparationUpdater() {
        }

        public void stateChanged(Electromagnet.ChangeEvent changeEvent) {
            MonitorPanel.this.fieldStrength = MonitorPanel.this.model.getTotalFieldStrengthAt(new Point2D.Double(MriConfig.SAMPLE_CHAMBER_WIDTH / 2.0, MriConfig.SAMPLE_CHAMBER_HEIGHT / 2.0));
            MonitorPanel.this.updatePanel();
        }
    }

    private class ModelChangeListener
    extends MriModel.ChangeAdapter {
        private ModelChangeListener() {
        }

        public void sampleMaterialChanged(SampleMaterial sampleMaterial) {
            MonitorPanel.this.updatePanel();
            MonitorPanel.this.makeImages(MonitorPanel.this.scale, sampleMaterial);
            MonitorPanel.this.lowerLine.setDipoleRepImage(MonitorPanel.this.lowerDipoleImage);
            MonitorPanel.this.upperLine.setDipoleRepImage(MonitorPanel.this.upperDipoleImage);
        }
    }

    private class SquiggleUpdater
    implements PhotonSource.RateChangeListener,
    PhotonSource.WavelengthChangeListener {
        private SquiggleUpdater() {
        }

        public void rateChangeOccurred(PhotonSource.RateChangeEvent rateChangeEvent) {
            MonitorPanel.this.adjustSquiggle();
        }

        public void wavelengthChanged(PhotonSource.WavelengthChangeEvent wavelengthChangeEvent) {
            MonitorPanel.this.adjustSquiggle();
        }
    }
}

