/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.view;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.mri.controller.AbstractMriModule;
import edu.colorado.phet.mri.model.Detector;
import edu.colorado.phet.mri.model.Dipole;
import edu.colorado.phet.mri.model.GradientElectromagnet;
import edu.colorado.phet.mri.model.LinearGradientMagnet;
import edu.colorado.phet.mri.model.MriEmittedPhoton;
import edu.colorado.phet.mri.model.MriModel;
import edu.colorado.phet.mri.model.PlaneWaveCycle;
import edu.colorado.phet.mri.model.PlaneWaveMedium;
import edu.colorado.phet.mri.model.RadiowaveSource;
import edu.colorado.phet.mri.model.SampleChamber;
import edu.colorado.phet.mri.model.SampleMaterial;
import edu.colorado.phet.mri.model.SimpleMagnet;
import edu.colorado.phet.mri.view.DetectorGraphic;
import edu.colorado.phet.mri.view.DipoleGraphic;
import edu.colorado.phet.mri.view.ElectromagnetGraphic;
import edu.colorado.phet.mri.view.GradientMagnetGraphic;
import edu.colorado.phet.mri.view.PhotonGraphic;
import edu.colorado.phet.mri.view.PlaneWaveGraphic;
import edu.colorado.phet.mri.view.RadiowaveSourceGraphic;
import edu.colorado.phet.mri.view.SampleChamberGraphic;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ModelElementGraphicManager
extends MriModel.ChangeAdapter {
    private AbstractMriModule module;
    private PhetPCanvas phetPCanvas;
    private PNode canvas;
    private HashMap modelElementToGraphicMap = new HashMap();
    private Set invisibleGraphicClasses = new HashSet();
    private PNode dipolesLayer = new PNode();
    private PNode rfLayer = new PNode();
    private PNode sampleChamberLayer = new PNode();
    private PNode magnetCoilLayer = new PNode();
    private PNode controlLayer = new PNode();
    private PNode headLayer = new PNode();
    private MriModel model;

    public ModelElementGraphicManager(AbstractMriModule abstractMriModule, PhetPCanvas phetPCanvas, PNode pNode) {
        this.module = abstractMriModule;
        this.phetPCanvas = phetPCanvas;
        this.canvas = pNode;
        this.model = (MriModel)abstractMriModule.getModel();
        this.model.addListener(new MriModel.ChangeAdapter(){

            public void sampleMaterialChanged(SampleMaterial sampleMaterial) {
                ModelElementGraphicManager.this.updateDipoleGraphics();
            }
        });
        pNode.addChild(this.magnetCoilLayer);
        pNode.addChild(this.headLayer);
        pNode.addChild(this.sampleChamberLayer);
        pNode.addChild(this.dipolesLayer);
        pNode.addChild(this.rfLayer);
        pNode.addChild(this.controlLayer);
    }

    public void scanModel(MriModel mriModel) {
        List list = mriModel.getModelElements();
        for (int i = 0; i < list.size(); ++i) {
            ModelElement modelElement = (ModelElement)list.get(i);
            this.modelElementAdded(modelElement);
        }
    }

    public void modelElementAdded(ModelElement modelElement) {
        PNode pNode = null;
        PNode pNode2 = this.canvas;
        if (modelElement instanceof Dipole) {
            pNode = new DipoleGraphic((Dipole)modelElement, this.model.getSampleMaterial());
            pNode2 = this.dipolesLayer;
        } else if (modelElement instanceof SampleChamber) {
            pNode = new SampleChamberGraphic((SampleChamber)modelElement);
            pNode2 = this.sampleChamberLayer;
        } else if (modelElement instanceof SimpleMagnet) {
            pNode = new ElectromagnetGraphic((GradientElectromagnet)modelElement);
            pNode2 = this.magnetCoilLayer;
        } else if (modelElement instanceof LinearGradientMagnet) {
            pNode = new GradientMagnetGraphic((GradientElectromagnet)modelElement);
            pNode2 = this.magnetCoilLayer;
        } else if (modelElement instanceof RadiowaveSource && !(modelElement instanceof PlaneWaveCycle)) {
            pNode = new RadiowaveSourceGraphic((RadiowaveSource)modelElement, this.module);
            pNode2 = this.controlLayer;
        } else if (modelElement instanceof Photon) {
            pNode = PhotonGraphic.getInstance((Photon)modelElement);
            pNode2 = this.rfLayer;
        } else if (modelElement instanceof Detector) {
            pNode = new DetectorGraphic((Detector)modelElement);
            pNode2 = this.controlLayer;
        } else if (modelElement instanceof PlaneWaveMedium) {
            PlaneWaveMedium planeWaveMedium = (PlaneWaveMedium)modelElement;
            double d = 0.25;
            if (planeWaveMedium.getSource() instanceof MriEmittedPhoton) {
                d = 0.5;
            }
            pNode = new PlaneWaveGraphic(planeWaveMedium, d, Color.black);
            pNode2 = this.rfLayer;
        }
        if (pNode != null) {
            if (this.invisibleGraphicClasses.contains(pNode.getClass())) {
                pNode.setVisible(false);
            }
            this.modelElementToGraphicMap.put(modelElement, new GraphicRecord(pNode, pNode2));
            this.addGraphic(pNode, pNode2);
        }
    }

    public void addGraphic(PNode pNode, PNode pNode2) {
        pNode2.addChild(pNode);
    }

    public void modelElementRemoved(ModelElement modelElement) {
        GraphicRecord graphicRecord = (GraphicRecord)this.modelElementToGraphicMap.get(modelElement);
        if (graphicRecord != null) {
            PNode pNode = graphicRecord.getLayer();
            PNode pNode2 = graphicRecord.getGraphic();
            pNode.removeChild(pNode2);
            this.modelElementToGraphicMap.remove(modelElement);
        }
    }

    public void setAllOfTypeVisible(Class clazz, boolean bl) {
        for (PNode pNode : this.canvas.getAllNodes()) {
            if (!clazz.isInstance(pNode)) continue;
            pNode.setVisible(bl);
        }
        if (!bl) {
            this.invisibleGraphicClasses.add(clazz);
        } else {
            this.invisibleGraphicClasses.remove(clazz);
        }
    }

    public PNode getControlLayer() {
        return this.controlLayer;
    }

    public PNode getHeadLayer() {
        return this.headLayer;
    }

    private void updateDipoleGraphics() {
        Iterator iterator = this.modelElementToGraphicMap.keySet().iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!(k instanceof Dipole)) continue;
            arrayList.add(k);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Dipole dipole = (Dipole)arrayList.get(i);
            this.modelElementRemoved(dipole);
            this.modelElementAdded(dipole);
        }
        arrayList.clear();
    }

    private static class GraphicRecord {
        private PNode graphic;
        private PNode layer;

        public GraphicRecord(PNode pNode, PNode pNode2) {
            this.graphic = pNode;
            this.layer = pNode2;
        }

        public PNode getGraphic() {
            return this.graphic;
        }

        public PNode getLayer() {
            return this.layer;
        }
    }
}

