/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.view;

import edu.colorado.phet.common.piccolophet.nodes.RegisterablePNode;
import edu.colorado.phet.common.piccolophet.util.PImageFactory;
import edu.colorado.phet.mri.MriResources;
import edu.colorado.phet.mri.model.Electromagnet;
import edu.colorado.phet.mri.model.GradientElectromagnet;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Dimension;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class GradientMagnetGraphic
extends RegisterablePNode
implements Electromagnet.ChangeListener {
    private int numSegments = 7;
    private PNode[] coilsGraphics = new PNode[this.numSegments];
    private PNode upperLead;
    private PNode lowerLead;
    private GradientElectromagnet magnet;
    private double scale;

    public GradientMagnetGraphic(GradientElectromagnet gradientElectromagnet) {
        this.magnet = gradientElectromagnet;
        this.scale = 1.0;
        gradientElectromagnet.addChangeListener(this);
        Rectangle2D rectangle2D = gradientElectromagnet.getBounds();
        this.setRegistrationPoint(rectangle2D.getWidth() / 2.0, rectangle2D.getHeight() / 2.0);
        Line2D.Double double_ = new Line2D.Double(-300.0, 10.0, 0.0, 10.0);
        Line2D.Double double_2 = new Line2D.Double(-300.0, rectangle2D.getHeight() - 10.0, 0.0, rectangle2D.getHeight() - 10.0);
        this.upperLead = new PPath(double_);
        this.lowerLead = new PPath(double_2);
        this.addChild(this.upperLead);
        this.addChild(this.lowerLead);
        this.createCoilGraphics(rectangle2D);
        this.update();
    }

    private void createCoilGraphics(Rectangle2D rectangle2D) {
        double d = this.magnet.getOrientation() == GradientElectromagnet.HORIZONTAL ? rectangle2D.getWidth() : rectangle2D.getHeight();
        double d2 = d / (double)this.numSegments;
        for (int i = 0; i < this.coilsGraphics.length; ++i) {
            PImage pImage = null;
            double d3 = (double)i * d2;
            if (this.magnet.getOrientation() == GradientElectromagnet.HORIZONTAL) {
                pImage = PImageFactory.create(MriResources.getImage("coil-1.png"), new Dimension((int)d2, (int)rectangle2D.getHeight()));
                pImage.setOffset(d3, 0.0);
            } else {
                pImage = PImageFactory.create(MriResources.getImage("coil-1.png"), new Dimension((int)d2, (int)rectangle2D.getWidth()));
                pImage.rotate(1.5707963267948966);
                pImage.translate(d3, -rectangle2D.getWidth());
            }
            this.addChild(pImage);
            this.coilsGraphics[i] = pImage;
        }
    }

    public void update() {
        this.setOffset(this.magnet.getPosition());
    }

    public void stateChanged(Electromagnet.ChangeEvent changeEvent) {
        this.update();
    }
}

