/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.view;

import edu.colorado.phet.common.phetcommon.util.PhysicsUtil;
import edu.colorado.phet.mri.model.MriModel;
import edu.colorado.phet.mri.model.RadiowaveSource;
import edu.colorado.phet.mri.view.EnergySquiggle;

public class EnergySquiggleUpdater {
    private EnergySquiggle energySquiggle;
    private MriModel model;
    private RadiowaveSource radiowaveSource;

    public EnergySquiggleUpdater(EnergySquiggle energySquiggle, MriModel mriModel) {
        this.energySquiggle = energySquiggle;
        this.model = mriModel;
        this.radiowaveSource = mriModel.getRadiowaveSource();
    }

    public void updateSquiggle(double d, double d2, double d3) {
        double d4 = this.radiowaveSource.getFrequency();
        double d5 = PhysicsUtil.frequencyToWavelength(d4);
        double d6 = this.radiowaveSource.getPower() / 100.0;
        this.energySquiggle.setTransparency((float)d6);
        double d7 = PhysicsUtil.frequencyToEnergy(d4) * d3;
        this.energySquiggle.update(d5, 0.0, (int)d7, 10);
        this.energySquiggle.setOffset(d, d2 - d7);
        boolean bl = this.model.isTransitionMatch();
        if (this.energySquiggle.isMatch() != bl) {
            this.energySquiggle.setMatch(bl);
            this.energySquiggle.update(d5, 0.0, (int)d7, 10);
        }
    }
}

