/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.view;

import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class EnergySquiggle
extends PNode {
    private boolean match;
    public static final Orientation VERTICAL = new Orientation();
    public static final Orientation HORIZONTAL = new Orientation();
    private double frequencyFactor = 1.0E-9;
    private PImage squiggleGraphic;
    private Orientation orientation;

    public EnergySquiggle(Orientation orientation) {
        this.orientation = orientation;
    }

    public void update(double d, double d2, int n, int n2) {
        if (this.squiggleGraphic != null) {
            this.removeChild(this.squiggleGraphic);
        }
        this.squiggleGraphic = new PImage(this.computeSquiggleImage(d, d2, n, n2));
        this.addChild(this.squiggleGraphic);
    }

    private BufferedImage computeSquiggleImage(double d, double d2, int n, int n2) {
        int n3 = n2;
        int n4 = n - 1;
        BufferedImage bufferedImage = new BufferedImage(n4 + 2 * n3, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int n5 = n2 / 2;
        int n6 = 0;
        double d3 = d * this.frequencyFactor;
        graphics2D.setColor(Color.black);
        for (int i = 0; i < n4 - n3 * 2; ++i) {
            int n7 = (int)(Math.sin(d2 + (double)i * Math.PI * 2.0 / d3) * (double)n2 / 2.0 + (double)(n2 / 2));
            for (int j = 0; j < n2; ++j) {
                if (j != n7) continue;
                graphics2D.drawLine(n6 + n3, n5, i + n3, n7);
                n6 = i;
                n5 = n7;
            }
        }
        Arrow arrow = new Arrow(new Point2D.Double(n3, n2 / 2), new Point2D.Double(0.0, n2 / 2), n3, (double)n2 * 1.2, 2.0);
        Arrow arrow2 = new Arrow(new Point2D.Double(n4 - n3, n2 / 2), new Point2D.Double(n4, n2 / 2), n3, (double)n2 * 1.2, 2.0);
        graphics2D.fill(arrow.getShape());
        graphics2D.fill(arrow2.getShape());
        graphics2D.dispose();
        if (this.orientation == VERTICAL) {
            bufferedImage = BufferedImageUtils.getRotatedImage(bufferedImage, 1.5707963267948966);
        }
        return bufferedImage;
    }

    public void setMatch(boolean bl) {
        this.match = bl;
        this.repaint();
    }

    public boolean isMatch() {
        return this.match;
    }

    public static class Orientation {
        private Orientation() {
        }
    }
}

