/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.piccolophet.nodes.RegisterablePNode;
import edu.colorado.phet.mri.MriResources;
import edu.colorado.phet.mri.model.Dipole;
import edu.colorado.phet.mri.model.SampleMaterial;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;

public class DipoleGraphic
extends RegisterablePNode
implements SimpleObserver {
    private PImage baseDipoleGraphic;
    private Dipole dipole;
    private BufferedImage baseImage;

    public static BufferedImage getDipoleImage(SampleMaterial sampleMaterial) {
        String string = null;
        if (sampleMaterial == SampleMaterial.HYDROGEN) {
            string = "dipole-5-hydrogen.gif";
        } else if (sampleMaterial == SampleMaterial.NITROGEN) {
            string = "dipole-5-nitrogen.gif";
        } else if (sampleMaterial == SampleMaterial.SODIUM) {
            string = "dipole-5-sodium.gif";
        } else if (sampleMaterial == SampleMaterial.CARBON_13) {
            string = "dipole-5-carbon.gif";
        } else if (sampleMaterial == SampleMaterial.OXYGEN) {
            string = "dipole-5-oxygen.gif";
        } else if (sampleMaterial == SampleMaterial.SULFUR) {
            string = "dipole-5-sulfur.gif";
        } else if (sampleMaterial == SampleMaterial.UNKNOWN) {
            string = "dipole-5-unknown.gif";
        }
        return MriResources.getImage(string);
    }

    public DipoleGraphic(Dipole dipole, SampleMaterial sampleMaterial) {
        this.dipole = dipole;
        dipole.addObserver(this);
        this.baseImage = DipoleGraphic.getDipoleImage(sampleMaterial);
        double d = 1.0;
        AffineTransform affineTransform = AffineTransform.getScaleInstance(d, d);
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY));
        this.baseImage = affineTransformOp.filter(this.baseImage, null);
        this.baseDipoleGraphic = new PImage(this.baseImage);
        this.addChild(this.baseDipoleGraphic);
        this.update();
    }

    public void update() {
        BufferedImage bufferedImage = BufferedImageUtils.getRotatedImage(this.baseImage, this.dipole.getOrientation());
        this.baseDipoleGraphic.setImage(bufferedImage);
        this.setRegistrationPoint(bufferedImage.getWidth() / 2, bufferedImage.getHeight() / 2);
        this.setOffset(this.dipole.getPosition());
    }
}

