/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.RegisterablePNode;
import edu.colorado.phet.mri.MriResources;
import edu.colorado.phet.mri.model.Detector;
import edu.colorado.phet.mri.util.RoundGradientPaint;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;

public class DetectorGraphic
extends PNode
implements SimpleObserver {
    static Color[] grayScale = new Color[256];
    static RoundGradientPaint[] gradientPaints;
    private Font font = new PhetFont(1, 16);
    private PPath displayPNode;
    private Detector detector;

    public DetectorGraphic(Detector detector) {
        detector.addObserver(this);
        this.detector = detector;
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(0.0, 0.0, detector.getBounds().getWidth(), detector.getBounds().getHeight(), 15.0, 15.0);
        PPath pPath = new PPath(double_);
        pPath.setStroke(new BasicStroke(3.0f));
        pPath.setPaint(new Color(150, 150, 150));
        PText pText = new PText(MriResources.getString("Misc.Detector"));
        pText.setFont(this.font);
        pText.setTextPaint(Color.white);
        pText.rotate(-1.5707963267948966);
        pText.setJustification(0.5f);
        pText.setOffset(5.0, ((RectangularShape)double_).getHeight() / 2.0);
        RegisterablePNode registerablePNode = new RegisterablePNode(pText);
        registerablePNode.setRegistrationPoint(0.0, -pText.getWidth() / 2.0);
        double d = 40.0;
        RoundRectangle2D.Double double_2 = new RoundRectangle2D.Double(detector.getBounds().getWidth() + 20.0, detector.getBounds().getHeight() / 2.0 - d / 2.0, d, d, 10.0, 10.0);
        double d2 = 20.0;
        Rectangle2D.Double double_3 = new Rectangle2D.Double(detector.getBounds().getWidth() / 2.0, detector.getBounds().getHeight() / 2.0 - d2 / 2.0, double_2.getBounds2D().getX(), d2);
        PPath pPath2 = new PPath(double_3);
        pPath2.setStroke(new BasicStroke(3.0f));
        pPath2.setStrokePaint(Color.black);
        pPath2.setPaint(new Color(150, 150, 150));
        this.displayPNode = new PPath(double_2);
        this.displayPNode.setStroke(new BasicStroke(3.0f));
        this.displayPNode.setStrokePaint(Color.black);
        this.displayPNode.setPaint(Color.white);
        this.addChild(pPath2);
        this.addChild(pPath);
        this.addChild(registerablePNode);
        this.addChild(this.displayPNode);
        this.setOffset(detector.getBounds().getX(), detector.getBounds().getY());
        double d3 = double_2.getBounds().getMinX() + double_2.getBounds().getWidth() / 2.0;
        double d4 = double_2.getBounds().getMinY() + double_2.getBounds().getHeight() / 2.0;
        for (int i = 0; i < gradientPaints.length; ++i) {
            double d5 = double_2.getBounds().getWidth() - double_2.getBounds().getWidth() * (double)i / (double)gradientPaints.length;
            DetectorGraphic.gradientPaints[i] = new RoundGradientPaint(d3, d4, grayScale[i], new Point2D.Double(0.0, d5), Color.white);
        }
    }

    public void update() {
        double d = Math.max(1.0 - (double)this.detector.getNumDetected() / 30.0, 0.0);
        RoundGradientPaint roundGradientPaint = gradientPaints[(int)(d * 255.0)];
        this.displayPNode.setPaint(roundGradientPaint);
    }

    static {
        for (int i = 0; i < grayScale.length; ++i) {
            DetectorGraphic.grayScale[i] = new Color(i, i, i);
        }
        gradientPaints = new RoundGradientPaint[256];
    }
}

