/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.view;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.mri.model.MriModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;

public class BFieldIndicatorB
extends PNode {
    private double maxLength;
    private PPath arrowPPath;
    private Paint arrowColor = new Color(255, 255, 255, 50);
    private double minLength;
    private Point2D location;
    private double strokeOpacity = 0.5;
    private Color strokePaint = new Color(0, 0, 0, (int)(this.strokeOpacity * 255.0));

    public BFieldIndicatorB(MriModel mriModel, Point2D point2D, double d, Paint paint) {
        this.location = point2D;
        this.maxLength = d;
        this.arrowColor = paint;
        mriModel.addListener(new MriModel.ChangeAdapter(){

            public void fieldChanged(MriModel mriModel) {
                BFieldIndicatorB.this.update(mriModel);
            }
        });
        this.update(mriModel);
    }

    private void update(MriModel mriModel) {
        if (this.arrowPPath != null) {
            this.removeChild(this.arrowPPath);
        }
        double d = mriModel.getTotalFieldStrengthAt(this.location);
        int n = MathUtil.getSign(d);
        double d2 = Math.abs(d / 3.0) * this.maxLength;
        d2 = Math.max(this.minLength, Math.min(d2, this.maxLength));
        Arrow arrow = new Arrow(new Point2D.Double(0.0, d2 * (double)n / 2.0), new Point2D.Double(0.0, d2 * (double)(-n) / 2.0), d2 / 2.0, d2 / 2.0, d2 / 4.0, 0.5, true);
        this.arrowPPath = new PPath(arrow.getShape());
        if (this.arrowColor != null) {
            this.arrowPPath.setPaint(this.arrowColor);
        }
        this.arrowPPath.setStrokePaint(this.strokePaint);
        this.addChild(this.arrowPPath);
    }
}

