/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.model;

import edu.colorado.phet.mri.MriConfig;
import edu.colorado.phet.mri.model.Dipole;
import edu.colorado.phet.mri.model.MriModel;
import edu.colorado.phet.mri.model.Sample;
import edu.colorado.phet.mri.model.Spin;
import java.awt.geom.Rectangle2D;

public class SampleChamber
extends Sample {
    private Rectangle2D bounds;

    public SampleChamber(Rectangle2D rectangle2D) {
        this.bounds = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public void createDipoles(MriModel mriModel, int n) {
        double d = MriConfig.SAMPLE_CHAMBER_WIDTH / MriConfig.SAMPLE_CHAMBER_HEIGHT;
        int n2 = 0;
        int n3 = 0;
        double d2 = -1.0;
        while (d2 < d) {
            n3 = n / ++n2;
            d2 = (double)n2 / (double)n3;
        }
        double d3 = MriConfig.SAMPLE_CHAMBER_WIDTH / (double)(n2 + 1);
        double d4 = MriConfig.SAMPLE_CHAMBER_HEIGHT / (double)(n3 + 1);
        int n4 = 0;
        for (int i = 1; i <= n3; ++i) {
            for (int j = 1; j <= n2; ++j) {
                double d5 = MriConfig.SAMPLE_CHAMBER_LOCATION.getX() + (double)j * d3;
                double d6 = MriConfig.SAMPLE_CHAMBER_LOCATION.getY() + (double)i * d4;
                Spin spin = ++n4 % 2 == 0 ? Spin.DOWN : Spin.UP;
                Dipole dipole = new Dipole();
                dipole.setPosition(d5, d6);
                dipole.setSpin(spin);
                mriModel.addModelElement(dipole);
            }
        }
    }
}

