/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.util.PhysicsUtil;
import edu.colorado.phet.common.quantum.model.Beam;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.mri.MriConfig;
import edu.colorado.phet.mri.model.SampleMaterial;
import edu.colorado.phet.mri.util.IScalar;
import java.awt.geom.Point2D;

public class RadiowaveSource
extends Beam
implements IScalar {
    private static final double DEFAULT_WAVELENGTH = PhysicsUtil.frequencyToWavelength(2000000.0);
    private static final double MAX_PHOTONS_PER_SEC = 5.0 / (MriConfig.DT / 1000.0);
    public static Orientation VERTICAL;
    public static Orientation HORIZONTAL;
    private double power;
    private double currentAmplitude;
    private double runningTime;
    private double period = 100.0;
    private double phaseAngle;

    public double getEnergy() {
        return PhysicsUtil.frequencyToEnergy(this.getFrequency());
    }

    public RadiowaveSource(Point2D point2D, double d, Vector2D vector2D) {
        this(point2D, d, vector2D, 0.0);
    }

    public RadiowaveSource(Point2D point2D, double d, Vector2D vector2D, double d2) {
        super(DEFAULT_WAVELENGTH, point2D, d, d, vector2D, 100.0, 0.0, Photon.DEFAULT_SPEED);
        this.setEnabled(true);
        this.setPower(0.0);
        this.phaseAngle = d2;
        this.setWavelength(5.0E-7);
        double d3 = 3.0 * SampleMaterial.HYDROGEN.getMu() / 2.0;
        double d4 = PhysicsUtil.frequencyToWavelength(d3);
        this.setWavelength(d4);
    }

    public Orientation getOrientation() {
        Orientation orientation = null;
        return orientation;
    }

    public double getValue() {
        return this.currentAmplitude;
    }

    public void stepInTime(double d) {
        super.stepInTime(d);
        if (this.isEnabled()) {
            this.runningTime += d;
            this.currentAmplitude = this.power * 0.5 * (1.0 + Math.sin(this.phaseAngle + this.runningTime % this.period / this.period * Math.PI * 2.0));
        } else {
            this.currentAmplitude = 0.0;
        }
    }

    public void setPower(double d) {
        this.power = d;
        this.setPhotonsPerSecond(MAX_PHOTONS_PER_SEC * this.power / 100.0);
    }

    public double getPower() {
        return this.power;
    }

    public double getFrequency() {
        return PhysicsUtil.wavelengthToFrequency(this.getWavelength());
    }

    public void setFrequency(double d) {
        this.setWavelength(PhysicsUtil.frequencyToWavelength(d));
        this.period = 1.0 / (d * MriConfig.ModelToView.FREQUENCY);
    }

    public static class Orientation {
    }
}

