/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.phetcommon.util.PhysicsUtil;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.common.quantum.model.PhotonEmissionListener;
import edu.colorado.phet.common.quantum.model.PhotonEmittedEvent;
import edu.colorado.phet.mri.MriConfig;
import edu.colorado.phet.mri.model.CollisionAgent;
import edu.colorado.phet.mri.model.DipoleMonitor;
import edu.colorado.phet.mri.model.DipoleOrientationAgent;
import edu.colorado.phet.mri.model.Electromagnet;
import edu.colorado.phet.mri.model.GradientElectromagnet;
import edu.colorado.phet.mri.model.PlaneWaveMedium;
import edu.colorado.phet.mri.model.RadiowaveSource;
import edu.colorado.phet.mri.model.Sample;
import edu.colorado.phet.mri.model.SampleMaterial;
import edu.colorado.phet.mri.model.SimpleMagnet;
import edu.colorado.phet.mri.model.ThermalNoise;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;

public class MriModel
extends BaseModel {
    private Rectangle2D bounds;
    private SimpleMagnet upperMagnet;
    private SimpleMagnet lowerMagnet;
    private ArrayList magnets = new ArrayList();
    private ArrayList photons = new ArrayList();
    private DipoleOrientationAgent dipoleOrientationAgent;
    private SampleMaterial sampleMaterial;
    private RadiowaveSource radiowaveSource;
    private DipoleMonitor dipoleMonitor;
    private EventChannel modelEventChannel = new EventChannel(ChangeListener.class);
    private ChangeListener listenerProxy = (ChangeListener)this.modelEventChannel.getListenerProxy();

    public MriModel(IClock iClock, Rectangle2D rectangle2D, Sample sample) {
        this.dipoleMonitor = new DipoleMonitor(this);
        this.bounds = rectangle2D;
        this.addModelElement(sample);
        double d = 30.0;
        Rectangle2D.Double double_ = new Rectangle2D.Double(MriConfig.SAMPLE_CHAMBER_LOCATION.getX(), MriConfig.SAMPLE_CHAMBER_LOCATION.getY(), MriConfig.SAMPLE_CHAMBER_WIDTH, MriConfig.SAMPLE_CHAMBER_HEIGHT);
        Point2D.Double double_2 = new Point2D.Double(((RectangularShape)double_).getX() + ((RectangularShape)double_).getWidth() / 2.0, ((RectangularShape)double_).getY() - d * 1.0);
        this.upperMagnet = new SimpleMagnet(double_2, ((RectangularShape)double_).getWidth(), d, iClock, GradientElectromagnet.HORIZONTAL);
        this.addModelElement(this.upperMagnet);
        Point2D.Double double_3 = new Point2D.Double(((RectangularShape)double_).getX() + ((RectangularShape)double_).getWidth() / 2.0, ((RectangularShape)double_).getY() + ((RectangularShape)double_).getHeight() + d * 2.0);
        this.lowerMagnet = new SimpleMagnet(double_3, ((RectangularShape)double_).getWidth(), d, iClock, GradientElectromagnet.HORIZONTAL);
        this.addModelElement(this.lowerMagnet);
        double d2 = MriConfig.SAMPLE_CHAMBER_WIDTH * 1.1;
        this.radiowaveSource = new RadiowaveSource((Point2D)new Point2D.Double(MriConfig.SAMPLE_CHAMBER_LOCATION.getX() + MriConfig.SAMPLE_CHAMBER_WIDTH / 2.0, ((Point2D)double_3).getY() + this.lowerMagnet.getBounds().getHeight()), d2, new Vector2D(0.0, -1.0));
        this.addModelElement(this.radiowaveSource);
        this.radiowaveSource.setEnabled(true);
        this.radiowaveSource.addPhotonEmittedListener(new PhotonEmissionListener(){

            public void photonEmitted(PhotonEmittedEvent photonEmittedEvent) {
                MriModel.this.addModelElement(photonEmittedEvent.getPhoton());
            }
        });
        PlaneWaveMedium planeWaveMedium = new PlaneWaveMedium(this.radiowaveSource, this.radiowaveSource.getPosition(), this.radiowaveSource.getLength(), 800.0, PlaneWaveMedium.NORTH, 10.0);
        this.addModelElement(planeWaveMedium);
        this.dipoleOrientationAgent = new DipoleOrientationAgent(this);
        this.lowerMagnet.addChangeListener(this.dipoleOrientationAgent);
        ThermalNoise thermalNoise = new ThermalNoise(MriConfig.MEAN_THERMAL_NOISE_INJECTION_TIME, this);
        this.addModelElement(thermalNoise);
        this.addModelElement(new CollisionAgent(this));
        this.setInitialConditions();
    }

    private void setInitialConditions() {
        this.upperMagnet.setFieldStrength(MriConfig.InitialConditions.FADING_MAGNET_FIELD);
        this.lowerMagnet.setFieldStrength(MriConfig.InitialConditions.FADING_MAGNET_FIELD);
    }

    public void addModelElement(ModelElement modelElement) {
        super.addModelElement(modelElement);
        if (modelElement instanceof Photon) {
            this.photons.add(modelElement);
        }
        if (modelElement instanceof Electromagnet) {
            Electromagnet electromagnet = (Electromagnet)modelElement;
            this.magnets.add(electromagnet);
            electromagnet.addChangeListener(new MagnetListener());
        }
        this.listenerProxy.modelElementAdded(modelElement);
    }

    public void removeModelElement(ModelElement modelElement) {
        super.removeModelElement(modelElement);
        if (modelElement instanceof Photon) {
            this.photons.remove(modelElement);
            ((Photon)modelElement).removeFromSystem();
        }
        if (modelElement instanceof PlaneWaveMedium) {
            ((PlaneWaveMedium)modelElement).leaveSystem();
        }
        if (modelElement instanceof Electromagnet) {
            Electromagnet electromagnet = (Electromagnet)modelElement;
            this.magnets.remove(modelElement);
            electromagnet.removeChangeListener(new MagnetListener());
        }
        this.listenerProxy.modelElementRemoved(modelElement);
    }

    public List getModelElements() {
        ArrayList<ModelElement> arrayList = new ArrayList<ModelElement>();
        for (int i = 0; i < this.numModelElements(); ++i) {
            arrayList.add(this.modelElementAt(i));
        }
        return arrayList;
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public Electromagnet getUpperMagnet() {
        return this.upperMagnet;
    }

    public Electromagnet getLowerMagnet() {
        return this.lowerMagnet;
    }

    public List getDipoles() {
        return this.dipoleMonitor.getDipoles();
    }

    public List getUpDipoles() {
        return this.dipoleMonitor.getUpDipoles();
    }

    public List getDownDipoles() {
        return this.dipoleMonitor.getDownDipoles();
    }

    public ArrayList getPhotons() {
        return this.photons;
    }

    public SampleMaterial getSampleMaterial() {
        return this.sampleMaterial;
    }

    public void setSampleMaterial(SampleMaterial sampleMaterial) {
        this.sampleMaterial = sampleMaterial;
        this.listenerProxy.sampleMaterialChanged(this.sampleMaterial);
    }

    public RadiowaveSource getRadiowaveSource() {
        return this.radiowaveSource;
    }

    public double getTotalFieldStrengthAt(Point2D point2D) {
        double d = 0.0;
        for (int i = 0; i < this.magnets.size(); ++i) {
            GradientElectromagnet gradientElectromagnet = (GradientElectromagnet)this.magnets.get(i);
            d += gradientElectromagnet.getFieldStrengthAtAbsolute(point2D);
        }
        return d;
    }

    public double determineDesiredFractionDown() {
        double d = this.getTotalFieldStrengthAt(new Point2D.Double());
        double d2 = 0.5 + 0.5 * d / 3.0;
        return d2 *= 0.9;
    }

    protected void stepInTime(double d) {
        super.stepInTime(d);
        ArrayList arrayList = this.getPhotons();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Photon photon = (Photon)arrayList.get(i);
            if (this.getBounds().contains(photon.getPosition())) continue;
            this.removeModelElement(photon);
        }
    }

    public boolean isTransitionMatch() {
        return Math.abs(this.getFieldEnergy() - this.radiowaveSource.getEnergy()) <= MriConfig.ENERGY_EPS;
    }

    private double getFieldEnergy() {
        return PhysicsUtil.frequencyToEnergy(this.getTotalFieldStrengthAt(this.getCenter()) * this.getSampleMaterial().getMu());
    }

    private Point2D getCenter() {
        return new Point2D.Double(this.getBounds().getCenterX(), this.getBounds().getCenterY());
    }

    public double getMatchingFrequency() {
        return PhysicsUtil.energyToFrequency(this.getFieldEnergy());
    }

    public double getMatchingMainMagnetField() {
        double d = this.radiowaveSource.getEnergy();
        return PhysicsUtil.energyToFrequency(d) / this.getSampleMaterial().getMu();
    }

    public void addListener(ChangeListener changeListener) {
        this.modelEventChannel.addListener(changeListener);
    }

    public static abstract class ChangeAdapter
    implements ChangeListener {
        public void modelElementAdded(ModelElement modelElement) {
        }

        public void modelElementRemoved(ModelElement modelElement) {
        }

        public void sampleMaterialChanged(SampleMaterial sampleMaterial) {
        }

        public void fieldChanged(MriModel mriModel) {
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void modelElementAdded(ModelElement var1);

        public void modelElementRemoved(ModelElement var1);

        public void sampleMaterialChanged(SampleMaterial var1);

        public void fieldChanged(MriModel var1);
    }

    private class MagnetListener
    implements Electromagnet.ChangeListener {
        private MagnetListener() {
        }

        public void stateChanged(Electromagnet.ChangeEvent changeEvent) {
            MriModel.this.listenerProxy.fieldChanged(MriModel.this);
        }
    }
}

