/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.mri.model.Dipole;
import edu.colorado.phet.mri.model.MriModel;
import edu.colorado.phet.mri.model.Spin;
import java.util.ArrayList;
import java.util.List;

public class DipoleMonitor
extends MriModel.ChangeAdapter
implements Dipole.ChangeListener {
    private List dipoles = new ArrayList();
    private List upDipoles = new ArrayList();
    private List downDipoles = new ArrayList();

    public DipoleMonitor(MriModel mriModel) {
        mriModel.addListener(this);
    }

    public void modelElementAdded(ModelElement modelElement) {
        if (modelElement instanceof Dipole) {
            Dipole dipole = (Dipole)modelElement;
            this.dipoles.add(dipole);
            List list = this.getSpinList(dipole);
            list.add(dipole);
            dipole.addChangeListener(this);
        }
    }

    public void modelElementRemoved(ModelElement modelElement) {
        if (modelElement instanceof Dipole) {
            Dipole dipole = (Dipole)modelElement;
            this.dipoles.remove(dipole);
            this.getSpinList(dipole).remove(dipole);
            dipole.removeChangeListener(this);
        }
    }

    public void spinChanged(Dipole.ChangeEvent changeEvent) {
        Dipole dipole = changeEvent.getDipole();
        this.upDipoles.remove(dipole);
        this.downDipoles.remove(dipole);
        this.getSpinList(dipole).add(dipole);
    }

    private List getSpinList(Dipole dipole) {
        List list = dipole.getSpin() == Spin.DOWN ? this.downDipoles : this.upDipoles;
        return list;
    }

    public List getDipoles() {
        return this.dipoles;
    }

    public List getUpDipoles() {
        return this.upDipoles;
    }

    public List getDownDipoles() {
        return this.downDipoles;
    }
}

