/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.PhysicsUtil;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.mri.MriConfig;
import edu.colorado.phet.mri.model.Dipole;
import edu.colorado.phet.mri.model.MriEmittedPhoton;
import edu.colorado.phet.mri.model.MriModel;
import edu.colorado.phet.mri.model.PlaneWaveCycle;
import edu.colorado.phet.mri.model.PlaneWaveMedium;
import edu.colorado.phet.mri.model.Spin;

public class DipoleFlipper
implements ModelElement {
    private Dipole dipole;
    private Spin targetSpin;
    private double timeout;
    private MriModel model;
    private boolean emitPhoton;
    private long elapsedTime;

    DipoleFlipper(Dipole dipole, Spin spin, double d, MriModel mriModel, boolean bl) {
        this.dipole = dipole;
        this.targetSpin = spin;
        this.timeout = d;
        this.model = mriModel;
        this.emitPhoton = bl;
    }

    public void stepInTime(double d) {
        this.elapsedTime = (long)((double)this.elapsedTime + d);
        if ((double)this.elapsedTime >= this.timeout) {
            if (this.dipole.getSpin() != this.targetSpin) {
                this.dipole.setSpin(this.targetSpin);
                if (this.emitPhoton && this.targetSpin == Spin.DOWN) {
                    this.emitPhoton();
                }
            }
            this.model.removeModelElement(this);
        }
    }

    private void emitPhoton() {
        Vector2D vector2D = new Vector2D(MriConfig.EMITTED_PHOTON_DIRECTION).normalize().scale(Photon.DEFAULT_SPEED);
        double d = PhysicsUtil.frequencyToWavelength(this.model.getLowerMagnet().getFieldStrength() * this.model.getSampleMaterial().getMu());
        MriEmittedPhoton mriEmittedPhoton = new MriEmittedPhoton();
        mriEmittedPhoton.setWavelength(d);
        mriEmittedPhoton.setPosition(this.dipole.getPosition());
        mriEmittedPhoton.setVelocity(vector2D);
        this.model.addModelElement(mriEmittedPhoton);
        PlaneWaveCycle planeWaveCycle = new PlaneWaveCycle(this.dipole.getPosition(), 10.0, new Vector2D(1.0, 0.0));
        planeWaveCycle.setWavelength(PhysicsUtil.frequencyToWavelength(4.2E7));
        planeWaveCycle.setPower(100.0);
        this.model.addModelElement(planeWaveCycle);
        PlaneWaveMedium planeWaveMedium = new PlaneWaveMedium(planeWaveCycle, planeWaveCycle.getPosition(), 20.0, this.model.getBounds().getMaxX() - planeWaveCycle.getPosition().getX(), PlaneWaveMedium.EAST, 10.0);
        this.model.addModelElement(planeWaveMedium);
        mriEmittedPhoton.addLeftSystemListener(new ModelElementRemover(planeWaveCycle, planeWaveMedium));
    }

    private class ModelElementRemover
    implements Photon.LeftSystemEventListener {
        private PlaneWaveCycle waveCycle;
        private PlaneWaveMedium planeWaveMedium;

        public ModelElementRemover(PlaneWaveCycle planeWaveCycle, PlaneWaveMedium planeWaveMedium) {
            this.waveCycle = planeWaveCycle;
            this.planeWaveMedium = planeWaveMedium;
        }

        public void leftSystemEventOccurred(Photon.LeftSystemEvent leftSystemEvent) {
            DipoleFlipper.this.model.removeModelElement(this.planeWaveMedium);
            DipoleFlipper.this.model.removeModelElement(this.waveCycle);
        }
    }
}

