/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.model;

import edu.colorado.phet.common.collision.Collidable;
import edu.colorado.phet.common.collision.CollidableAdapter;
import edu.colorado.phet.common.mechanics.Body;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.quantum.model.Photon;
import edu.colorado.phet.mri.MriConfig;
import edu.colorado.phet.mri.model.Spin;
import java.awt.geom.Point2D;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Random;

public class Dipole
extends Body
implements Collidable {
    private static EventChannel classEventChannel = new EventChannel(ClassListener.class);
    private static ClassListener classListenerProxy = (ClassListener)classEventChannel.getListenerProxy();
    private double precession = MriConfig.InitialConditions.DIPOLE_PRECESSION;
    private Spin spin;
    private double orientation;
    private CollidableAdapter collidableAdapter;
    private IOrientationBehavior orientationBehavior;
    private double oldOrientation;
    private EventChannel changeEventChannel = new EventChannel(ChangeListener.class);
    private ChangeListener changeListenerProxy = (ChangeListener)this.changeEventChannel.getListenerProxy();

    public Dipole() {
        this.collidableAdapter = new CollidableAdapter(this);
        this.orientationBehavior = new KinematicBehavior(this);
        classListenerProxy.instanceCreated(this);
    }

    public void stepInTime(double d) {
        double d2 = (double)(this.spin == Spin.DOWN ? 1 : -1) * Math.PI / 2.0;
        if (this.oldOrientation != d2) {
            this.orientationBehavior.startMovingNow();
            this.oldOrientation = d2;
        }
        Vector2D vector2D = new Vector2D(1.0, 0.0).rotate(d2);
        this.orientationBehavior.setOrientation(vector2D, d);
        this.notifyObservers();
    }

    public double getOrientation() {
        return this.orientation;
    }

    private void setOrientation(double d) {
        this.orientation = d;
    }

    public Spin getSpin() {
        return this.spin;
    }

    public void setSpin(Spin spin) {
        this.spin = spin;
        this.changeListenerProxy.spinChanged(new ChangeEvent(this));
    }

    public void flip() {
        Spin spin = this.getSpin() == Spin.UP ? Spin.DOWN : Spin.UP;
        this.setSpin(spin);
    }

    public double getRadius() {
        return 30.0;
    }

    public void setVelocity(double d, double d2) {
        this.collidableAdapter.updateVelocity();
        super.setVelocity(d, d2);
    }

    public void setPosition(double d, double d2) {
        this.collidableAdapter.updatePosition();
        super.setPosition(d, d2);
    }

    public void setPosition(Point2D point2D) {
        this.collidableAdapter.updatePosition();
        super.setPosition(point2D);
    }

    public void collideWithPhoton(Photon photon) {
        this.setSpin(Spin.UP);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeEventChannel.addListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeEventChannel.removeListener(changeListener);
    }

    private static abstract class AbstractBehavior
    implements IOrientationBehavior {
        private Dipole _compassModel;

        public AbstractBehavior(Dipole dipole) {
            this._compassModel = dipole;
        }

        public Dipole getCompass() {
            return this._compassModel;
        }

        public void startMovingNow() {
        }
    }

    public class ChangeEvent
    extends EventObject {
        public ChangeEvent(Dipole dipole2) {
            super(dipole2);
        }

        public Dipole getDipole() {
            return (Dipole)this.getSource();
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void spinChanged(ChangeEvent var1);
    }

    public static interface ClassListener
    extends EventListener {
        public void instanceCreated(Dipole var1);
    }

    private static interface IOrientationBehavior {
        public void setOrientation(Vector2D var1, double var2);

        public void startMovingNow();
    }

    private static class KinematicBehavior
    extends AbstractBehavior {
        public static double SENSITIVITY = 0.003;
        public static double DAMPING = 0.035;
        private static final double THRESHOLD = Math.toRadians(0.2);
        private static Random random = new Random();
        private double _theta = 0.0;
        private double _omega = 0.0;
        private double _alpha = 0.0;

        public KinematicBehavior(Dipole dipole) {
            super(dipole);
        }

        public void setOrientation(Vector2D vector2D, double d) {
            double d2;
            double d3 = vector2D.getMagnitude();
            double d4 = vector2D.getAngle();
            double d5 = d2 = d3 == 0.0 ? 0.0 : d4 - this._theta;
            if (Math.abs(d2) < THRESHOLD) {
                this._theta = d4;
                this._omega = 0.0;
                this._alpha = 0.0;
                this.getCompass().setOrientation(this._theta);
            } else {
                double d6 = this._theta;
                double d7 = SENSITIVITY * Math.sin(d2) * d3 - DAMPING * this._omega;
                this._theta = this._theta + this._omega * d + 0.5 * d7 * d * d;
                if (this._theta != d6) {
                    this.getCompass().setOrientation(this._theta);
                }
                double d8 = this._omega + d7 * d;
                this._alpha = SENSITIVITY * Math.sin(d2) * d3 - DAMPING * d8;
                this._omega += 0.5 * (this._alpha + d7) * d;
            }
        }

        public void startMovingNow() {
            int n = random.nextBoolean() ? 1 : -1;
            this._omega = 0.03 * (double)n;
        }
    }
}

