/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.controller;

import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.common.piccolophet.help.MotionHelpBalloon;
import edu.colorado.phet.common.quantum.model.PhotonSource;
import edu.colorado.phet.mri.MriConfig;
import edu.colorado.phet.mri.MriResources;
import edu.colorado.phet.mri.controller.AbstractMriModule;
import edu.colorado.phet.mri.controller.NmrControlPanel;
import edu.colorado.phet.mri.model.MriModel;
import edu.colorado.phet.mri.model.RadiowaveSource;
import edu.colorado.phet.mri.model.SampleChamber;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class NmrModule
extends AbstractMriModule {
    private static String name = MriResources.getString("Module.NmrTitle");
    static SampleChamber sampleChamber = new SampleChamber(new Rectangle2D.Double(MriConfig.SAMPLE_CHAMBER_LOCATION.getX(), MriConfig.SAMPLE_CHAMBER_LOCATION.getY(), MriConfig.SAMPLE_CHAMBER_WIDTH, MriConfig.SAMPLE_CHAMBER_HEIGHT));

    public NmrModule() {
        super(name, (IClock)new SwingClock(delay, dt), sampleChamber);
        this.setLogoPanelVisible(false);
    }

    public boolean auxiliarySquiggleVisible() {
        return true;
    }

    protected void init() {
        super.init();
        this.setControlPanel(new NmrControlPanel(this));
        sampleChamber.createDipoles((MriModel)this.getModel(), 20);
        this.setEmRep(WAVE_VIEW);
        this.createWiggleMe();
    }

    private void createWiggleMe() {
        Point2D point2D = ((MriModel)this.getModel()).getRadiowaveSource().getPosition();
        MotionHelpBalloon motionHelpBalloon = new MotionHelpBalloon(this.getPhetPCanvas(), MriResources.getString("Application.WiggleMe"));
        motionHelpBalloon.setOffset(50.0, 100.0);
        motionHelpBalloon.setBalloonFillPaint(new Color(255, 255, 100));
        motionHelpBalloon.setBalloonVisible(true);
        motionHelpBalloon.setBalloonStroke(new BasicStroke(1.0f));
        this.getPhetPCanvas().addScreenChild(motionHelpBalloon);
        motionHelpBalloon.setVisible(true);
        motionHelpBalloon.animateTo(((MriModel)this.getModel()).getRadiowaveSource().getPosition().getX() - 120.0, ((MriModel)this.getModel()).getRadiowaveSource().getPosition().getY() - 20.0);
        PhotonSourceListener photonSourceListener = new PhotonSourceListener(motionHelpBalloon);
        ((MriModel)this.getModel()).getRadiowaveSource().addRateChangeListener(photonSourceListener);
        ((MriModel)this.getModel()).getRadiowaveSource().addWavelengthChangeListener(photonSourceListener);
    }

    private class PhotonSourceListener
    implements PhotonSource.RateChangeListener,
    PhotonSource.WavelengthChangeListener {
        private final MotionHelpBalloon wiggleMe;

        public PhotonSourceListener(MotionHelpBalloon motionHelpBalloon) {
            this.wiggleMe = motionHelpBalloon;
        }

        public void rateChangeOccurred(PhotonSource.RateChangeEvent rateChangeEvent) {
            ((RadiowaveSource)rateChangeEvent.getSource()).removeListener(this);
            NmrModule.this.getPhetPCanvas().removeScreenChild(this.wiggleMe);
        }

        public void wavelengthChanged(PhotonSource.WavelengthChangeEvent wavelengthChangeEvent) {
            ((RadiowaveSource)wavelengthChangeEvent.getSource()).removeListener(this);
            NmrModule.this.getPhetPCanvas().removeScreenChild(this.wiggleMe);
        }
    }
}

