/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.mri.controller;

import edu.colorado.phet.mri.MriResources;
import edu.colorado.phet.mri.model.MriModel;
import edu.colorado.phet.mri.util.ControlBorderFactory;
import edu.colorado.phet.mri.util.SliderControl;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;

public class FadingMagnetControl
extends SliderControl {
    private static double MIN_FIELD = 0.0;
    private static double DEFAULT_FIELD = 0.75;

    public FadingMagnetControl(final MriModel mriModel) {
        super(DEFAULT_FIELD, MIN_FIELD, 3.0, 0.5, 1, 2, MriResources.getString("ControlPanel.MagneticField") + ":", MriResources.getString("ControlPanel.Tesla"), 5, new Insets(0, 0, 0, 0));
        this.setTextEditable(true);
        this.setBorder(ControlBorderFactory.createPrimaryBorder(MriResources.getString("ControlPanel.MainMagnet")));
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                FadingMagnetControl.this.updateMagnets(mriModel);
            }
        });
        this.updateMagnets(mriModel);
        this.getSlider().addMouseListener(new MouseInputAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mriModel.isTransitionMatch()) {
                    double d = mriModel.getMatchingMainMagnetField();
                    System.out.println("magnet strength=" + d);
                    FadingMagnetControl.this.setValue(d);
                }
            }
        });
    }

    private void updateMagnets(MriModel mriModel) {
        mriModel.getUpperMagnet().setFieldStrength(this.getValue() / 2.0);
        mriModel.getLowerMagnet().setFieldStrength(this.getValue() / 2.0);
    }
}

