/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.colorvision.view;

import edu.colorado.phet.colorvision.model.Spotlight;
import edu.colorado.phet.colorvision.view.BoundsOutliner;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class SpotlightGraphic
extends PhetImageGraphic
implements SimpleObserver {
    private Spotlight _spotlightModel;
    private double _x;
    private double _y;
    private double _direction;

    public SpotlightGraphic(ApparatusPanel apparatusPanel, Spotlight spotlight) {
        super((Component)apparatusPanel, "color-vision/images/spotlight.png");
        this._spotlightModel = spotlight;
        this.update();
    }

    public void update() {
        double d = this._spotlightModel.getX();
        double d2 = this._spotlightModel.getY();
        double d3 = this._spotlightModel.getDirection();
        if (d != this._x || this._y != d2 || this._direction != d3) {
            BufferedImage bufferedImage = super.getImage();
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            this._x = (int)(d - (double)n + 130.0);
            this._y = (int)(d2 - (double)(n2 / 2));
            this._direction = d3;
            double d4 = Math.toRadians(d3);
            int n3 = n - 130;
            int n4 = n2 / 2;
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(0.0, 0.0);
            affineTransform.translate(this._x, this._y);
            affineTransform.rotate(d4, n3, n4);
            super.setTransform(affineTransform);
            super.repaint();
        }
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isVisible()) {
            super.paint(graphics2D);
            BoundsOutliner.paint(graphics2D, this);
        }
    }
}

