/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.colorvision.view;

import edu.colorado.phet.colorvision.model.Filter;
import edu.colorado.phet.colorvision.view.BoundsOutliner;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class FilterGraphic
extends PhetGraphic
implements SimpleObserver {
    private Filter _filterModel;
    private Shape _exterior;
    private Shape _interior;
    private Shape _lens;
    private double _x;

    public FilterGraphic(Component component, Filter filter) {
        super(component);
        this._filterModel = filter;
        this.update();
    }

    protected Rectangle determineBounds() {
        Rectangle rectangle = null;
        if (this._exterior != null) {
            rectangle = new Rectangle(this._exterior.getBounds());
        }
        return rectangle;
    }

    public void update() {
        double d = this._filterModel.getX();
        double d2 = this._filterModel.getY();
        if (d != this._x || d2 != d2) {
            Area area = new Area();
            Ellipse2D.Double double_ = new Ellipse2D.Double(d, d2, 20.0, 150.0);
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d + 10.0, d2, 10.0, 150.0);
            Ellipse2D.Double double_3 = new Ellipse2D.Double(d + 10.0, d2, 20.0, 150.0);
            area.add(new Area(double_));
            area.add(new Area(double_3));
            area.add(new Area(double_2));
            this._exterior = area;
            this._interior = new Ellipse2D.Double(d, d2, 20.0, 150.0);
            this._lens = new Ellipse2D.Double(d + 4.0, d2 + 4.0, 12.0, 142.0);
        }
        super.repaint();
    }

    public void paint(Graphics2D graphics2D) {
        if (super.isVisible() && this._filterModel.isEnabled()) {
            RenderingHints renderingHints = graphics2D.getRenderingHints();
            Paint paint = graphics2D.getPaint();
            RenderingHints renderingHints2 = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHints(renderingHints2);
            graphics2D.setPaint(Color.DARK_GRAY);
            graphics2D.fill(this._exterior);
            graphics2D.setPaint(Color.GRAY);
            graphics2D.fill(this._interior);
            graphics2D.setPaint(this._filterModel.getTransmissionPeak());
            graphics2D.fill(this._lens);
            graphics2D.setPaint(paint);
            graphics2D.setRenderingHints(renderingHints);
            BoundsOutliner.paint(graphics2D, this);
        }
    }
}

