/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.colorvision.view;

import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;

public class BoundsOutliner {
    private static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    private static final Paint DEFAULT_PAINT = Color.RED;
    private static boolean _enabled = false;

    private BoundsOutliner() {
    }

    public static void setEnabled(boolean bl) {
        _enabled = bl;
    }

    public static void paint(Graphics2D graphics2D, PhetGraphic phetGraphic) {
        if (_enabled) {
            BoundsOutliner.paint(graphics2D, phetGraphic, DEFAULT_PAINT, DEFAULT_STROKE);
        }
    }

    public static void paint(Graphics2D graphics2D, PhetGraphic phetGraphic, Paint paint) {
        if (_enabled) {
            BoundsOutliner.paint(graphics2D, phetGraphic, paint, DEFAULT_STROKE);
        }
    }

    public static void paint(Graphics2D graphics2D, PhetGraphic phetGraphic, Paint paint, Stroke stroke) {
        if (_enabled) {
            BoundsOutliner.paint(graphics2D, phetGraphic.getBounds(), paint, stroke);
        }
    }

    public static void paint(Graphics2D graphics2D, Rectangle rectangle, Paint paint, Stroke stroke) {
        if (_enabled) {
            Paint paint2 = graphics2D.getPaint();
            Stroke stroke2 = graphics2D.getStroke();
            Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            graphics2D.draw(rectangle2);
            graphics2D.setPaint(paint2);
            graphics2D.setStroke(stroke2);
        }
    }
}

