/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.colorvision.model;

import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;

public class Filter
extends SimpleObservable {
    private double _x = 0.0;
    private double _y = 0.0;
    private boolean _enabled;
    private VisibleColor _transmissionPeak = VisibleColor.WHITE;
    private double _transmissionWidth = 50.0;

    public void setLocation(double d, double d2) {
        this._x = d;
        this._y = d2;
        this._enabled = true;
        this.notifyObservers();
    }

    public double getX() {
        return this._x;
    }

    public double getY() {
        return this._y;
    }

    public void setEnabled(boolean bl) {
        this._enabled = bl;
        this.notifyObservers();
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public VisibleColor getTransmissionPeak() {
        return this._transmissionPeak;
    }

    public void setTransmissionPeak(VisibleColor visibleColor) {
        this._transmissionPeak = visibleColor;
        this.notifyObservers();
    }

    public void setTransmissionPeak(double d) {
        this.setTransmissionPeak(new VisibleColor(d));
    }

    public double getTransmissionWidth() {
        return this._transmissionWidth;
    }

    public VisibleColor colorPassed(VisibleColor visibleColor) {
        VisibleColor visibleColor2 = null;
        if (!this._enabled) {
            visibleColor2 = visibleColor;
        } else if (visibleColor.equals(VisibleColor.WHITE)) {
            visibleColor2 = this._transmissionPeak;
        } else {
            double d = this.percentPassed(visibleColor);
            if (d == 0.0) {
                visibleColor2 = VisibleColor.INVISIBLE;
            } else {
                int n = visibleColor.getRed();
                int n2 = visibleColor.getGreen();
                int n3 = visibleColor.getBlue();
                int n4 = (int)(d / 100.0 * 255.0);
                visibleColor2 = new VisibleColor(n, n2, n3, n4);
            }
        }
        return visibleColor2;
    }

    public double percentPassed(VisibleColor visibleColor) {
        double d = visibleColor.getWavelength();
        double d2 = 0.0;
        double d3 = this._transmissionPeak.getWavelength();
        double d4 = this._transmissionWidth / 2.0;
        d2 = d == 0.0 ? 100.0 : (d < d3 - d4 || d > d3 + d4 ? 0.0 : 100.0 - Math.abs(d3 - d) / d4 * 100.0);
        return d2;
    }
}

