/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.colorvision.help;

import edu.colorado.phet.colorvision.view.BoundsOutliner;
import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;

public class WiggleMe
extends PhetGraphic
implements ModelElement {
    private static int DEFAULT_CYCLE_LENGTH = 10;
    private Component _component;
    private BaseModel _model;
    private PhetGraphic _graphic;
    private Point _location;
    private Point _graphicLocation;
    private Dimension _wiggleTravel;
    private double _cycles;
    private int _cycleLength;
    private boolean _running;

    public WiggleMe(Component component, BaseModel baseModel, PhetGraphic phetGraphic) {
        super(component);
        this._component = component;
        this._model = baseModel;
        this._graphic = phetGraphic;
        this._location = new Point(0, 0);
        this._graphicLocation = new Point(0, 0);
        this._wiggleTravel = new Dimension(10, 10);
        this._cycles = 0.0;
        this._cycleLength = DEFAULT_CYCLE_LENGTH;
        this._running = false;
    }

    protected WiggleMe(Component component, BaseModel baseModel) {
        this(component, baseModel, null);
    }

    public void setGraphic(PhetGraphic phetGraphic) {
        this._graphic = phetGraphic;
    }

    public void setLocation(Point point) {
        this._location.setLocation(point);
        this._graphicLocation.setLocation(point);
        this.repaint();
    }

    public void setLocation(int n, int n2) {
        this.setLocation(new Point(n, n2));
    }

    public Point getLocation() {
        return new Point(this._location);
    }

    public void setWiggleTravel(Dimension dimension) {
        this._wiggleTravel.setSize(dimension);
    }

    public void setCycleLength(int n) {
        this._cycleLength = n;
    }

    public Rectangle getBounds() {
        return this.determineBounds();
    }

    protected Rectangle determineBounds() {
        Rectangle rectangle = null;
        if (this._graphic != null) {
            int n = this._location.x;
            int n2 = this._location.y;
            int n3 = this._graphic.getBounds().width + this._wiggleTravel.width;
            int n4 = this._graphic.getBounds().height + this._wiggleTravel.height;
            rectangle = new Rectangle(n, n2, n3, n4);
        }
        return rectangle;
    }

    public void start() {
        if (!this._running) {
            this._running = true;
            this._model.addModelElement(this);
        }
    }

    public void stop() {
        if (this._running) {
            this._running = false;
            this._model.removeModelElement(this);
        }
    }

    public boolean isRunning() {
        return this._running;
    }

    public void stepInTime(double d) {
        if (this._graphic != null) {
            this._cycles += 1.0 / (double)this._cycleLength;
            int n = (int)((double)(this._location.x + this._wiggleTravel.width / 2) + (double)(this._wiggleTravel.width / 2) * Math.cos(this._cycles));
            int n2 = (int)((double)(this._location.y + this._wiggleTravel.height / 2) + (double)(this._wiggleTravel.height / 2) * Math.sin(this._cycles));
            this._graphicLocation.setLocation(n, n2);
            this.repaint();
        }
    }

    public void repaint() {
        Rectangle rectangle = this.getBounds();
        this._component.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void paint(Graphics2D graphics2D) {
        if (super.isVisible()) {
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(this._graphicLocation.x, this._graphicLocation.y);
            this._graphic.paint(graphics2D);
            graphics2D.setTransform(affineTransform);
            BoundsOutliner.paint(graphics2D, this);
        }
    }
}

