/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.colorvision.control;

import edu.colorado.phet.colorvision.view.BoundsOutliner;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.MouseInputAdapter;

public class ToggleSwitch
extends PhetImageGraphic {
    private String _onImageName;
    private String _offImageName;
    private boolean _on;
    private EventListenerList _listenerList;

    public ToggleSwitch(Component component, String string, String string2) {
        super(component, string2);
        this._onImageName = string;
        this._offImageName = string2;
        this._listenerList = new EventListenerList();
        super.setCursorHand();
        super.addMouseInputListener(new ToggleSwitchMouseInputListener());
        this._on = true;
        this.setOn(false);
    }

    public void setOn(boolean bl) {
        if (bl != this._on) {
            this._on = bl;
            this.setImageResourceName(bl ? this._onImageName : this._offImageName);
            this.fireChangeEvent(new ChangeEvent(this));
            this.repaint();
        }
    }

    public boolean isOn() {
        return this._on;
    }

    public void paint(Graphics2D graphics2D) {
        if (this.isVisible()) {
            super.paint(graphics2D);
            BoundsOutliner.paint(graphics2D, this);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listenerList.add(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent(ChangeEvent changeEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    private class ToggleSwitchMouseInputListener
    extends MouseInputAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            ToggleSwitch.this.setOn(!ToggleSwitch.this._on);
        }
    }
}

