/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.colorvision.control;

import edu.colorado.phet.colorvision.ColorVisionStrings;
import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class SingleBulbControlPanel
extends ControlPanel
implements ActionListener {
    private JRadioButton _whiteRadioButton;
    private JRadioButton _monochromaticRadioButton;
    private JRadioButton _photonsRadioButton;
    private JRadioButton _solidRadioButton;
    private EventListenerList _listenerList = new EventListenerList();

    public SingleBulbControlPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalStrut(150));
        JPanel jPanel2 = new JPanel();
        Serializable serializable = new TitledBorder(ColorVisionStrings.BULB_TYPE_TITLE);
        Serializable serializable2 = new PhetFont(PhetFont.getDefaultFontSize() + 4);
        ((TitledBorder)serializable).setTitleFont((Font)serializable2);
        jPanel2.setBorder((Border)((Object)serializable));
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this._whiteRadioButton = new JRadioButton(ColorVisionStrings.BULB_TYPE_WHITE);
        this._monochromaticRadioButton = new JRadioButton(ColorVisionStrings.BULB_TYPE_MONOCHROMATIC);
        jPanel2.add(this._whiteRadioButton);
        jPanel2.add(this._monochromaticRadioButton);
        Serializable serializable3 = new ButtonGroup();
        ((ButtonGroup)serializable3).add(this._whiteRadioButton);
        ((ButtonGroup)serializable3).add(this._monochromaticRadioButton);
        serializable = new JPanel();
        serializable2 = new TitledBorder(ColorVisionStrings.BEAM_TYPE_TITLE);
        serializable3 = new PhetFont(PhetFont.getDefaultFontSize() + 4);
        ((TitledBorder)serializable2).setTitleFont((Font)serializable3);
        ((JComponent)serializable).setBorder((Border)((Object)serializable2));
        ((Container)serializable).setLayout(new BoxLayout((Container)serializable, 1));
        this._photonsRadioButton = new JRadioButton(ColorVisionStrings.BEAM_TYPE_PHOTONS);
        this._solidRadioButton = new JRadioButton(ColorVisionStrings.BEAM_TYPE_SOLID);
        ((Container)serializable).add(this._photonsRadioButton);
        ((Container)serializable).add(this._solidRadioButton);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._photonsRadioButton);
        buttonGroup.add(this._solidRadioButton);
        serializable2 = new JPanel();
        serializable3 = new BorderLayout();
        ((BorderLayout)serializable3).setVgap(20);
        ((Container)serializable2).setLayout((LayoutManager)((Object)serializable3));
        ((Container)serializable2).add(jPanel, "North");
        ((Container)serializable2).add(jPanel2, "Center");
        ((Container)serializable2).add((Component)serializable, "South");
        this._whiteRadioButton.addActionListener(this);
        this._monochromaticRadioButton.addActionListener(this);
        this._solidRadioButton.addActionListener(this);
        this._photonsRadioButton.addActionListener(this);
        this._whiteRadioButton.setSelected(true);
        this._solidRadioButton.setSelected(true);
        super.addControlFullWidth((Component)serializable2);
    }

    public int getBulbType() {
        int n = 1;
        if (this._whiteRadioButton.isSelected()) {
            n = 0;
        }
        return n;
    }

    public void setBulbType(int n) {
        if (n == 0) {
            this._whiteRadioButton.setSelected(true);
        } else if (n == 1) {
            this._monochromaticRadioButton.setSelected(true);
        } else {
            throw new IllegalArgumentException("invalid bulb type: " + n);
        }
        this.fireChangeEvent(new ChangeEvent(this));
    }

    public int getBeamType() {
        int n = 3;
        if (this._photonsRadioButton.isSelected()) {
            n = 2;
        }
        return n;
    }

    public void setBeamType(int n) {
        if (n == 3) {
            this._solidRadioButton.setSelected(true);
        } else if (n == 2) {
            this._photonsRadioButton.setSelected(true);
        } else {
            throw new IllegalArgumentException("invalid beam type: " + n);
        }
        this.fireChangeEvent(new ChangeEvent(this));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.fireChangeEvent(new ChangeEvent(this));
    }

    public void addChangeListener(ChangeListener changeListener) {
        this._listenerList.add(ChangeListener.class, changeListener);
    }

    private void fireChangeEvent(ChangeEvent changeEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }
}

