/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.colorvision;

import edu.colorado.phet.colorvision.ColorVisionConstants;
import edu.colorado.phet.colorvision.ColorVisionStrings;
import edu.colorado.phet.colorvision.control.ColorIntensitySlider;
import edu.colorado.phet.colorvision.control.RgbBulbsControlPanel;
import edu.colorado.phet.colorvision.event.VisibleColorChangeEvent;
import edu.colorado.phet.colorvision.event.VisibleColorChangeListener;
import edu.colorado.phet.colorvision.help.IntensitySliderWiggleMe;
import edu.colorado.phet.colorvision.help.WiggleMe;
import edu.colorado.phet.colorvision.model.Person;
import edu.colorado.phet.colorvision.model.PhotonBeam;
import edu.colorado.phet.colorvision.model.Spotlight;
import edu.colorado.phet.colorvision.view.PersonGraphic;
import edu.colorado.phet.colorvision.view.PhotonBeamGraphic;
import edu.colorado.phet.colorvision.view.SpotlightGraphic;
import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.common.phetgraphics.application.PhetGraphicsModule;
import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel3;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RgbBulbsModule
extends PhetGraphicsModule
implements VisibleColorChangeListener,
ChangeListener {
    private static final Color APPARATUS_BACKGROUND = ColorVisionConstants.APPARATUS_BACKGROUND;
    private static final Point RED_SLIDER_LOCATION = new Point(50, 85);
    private static final Point GREEN_SLIDER_LOCATION = new Point(50, 260);
    private static final Point BLUE_SLIDER_LOCATION = new Point(50, 435);
    private static final Point WIGGLE_ME_LOCATION = new Point(90, 195);
    private static final Dimension INTENSITY_SLIDER_SIZE = new Dimension(35, 125);
    private static final Rectangle BEAM_BOUNDS = new Rectangle(120, 105, 430, 440);
    private Person _personModel;
    private Spotlight _redSpotlightModel;
    private Spotlight _blueSpotlightModel;
    private Spotlight _greenSpotlightModel;
    private PhotonBeam _redPhotonBeamModel;
    private PhotonBeam _greenPhotonBeamModel;
    private PhotonBeam _bluePhotonBeamModel;
    private ColorIntensitySlider _redSlider;
    private ColorIntensitySlider _greenSlider;
    private ColorIntensitySlider _blueSlider;
    private WiggleMe _wiggleMe;

    public RgbBulbsModule() {
        super(ColorVisionStrings.RGB_BULBS_MODULE_TITLE, new SwingClock(40, 1.0));
        BaseModel baseModel = new BaseModel();
        this.setModel(baseModel);
        this._personModel = new Person();
        this._personModel.setLocation(450.0, 25.0);
        this._redSpotlightModel = new Spotlight();
        this._redSpotlightModel.setColor(VisibleColor.RED);
        this._redSpotlightModel.setIntensity(0.0);
        this._redSpotlightModel.setLocation(120.0, 105.0);
        this._redSpotlightModel.setDirection(27.0);
        this._greenSpotlightModel = new Spotlight();
        this._greenSpotlightModel.setColor(VisibleColor.GREEN);
        this._greenSpotlightModel.setIntensity(0.0);
        this._greenSpotlightModel.setLocation(120.0, 325.0);
        this._greenSpotlightModel.setDirection(0.0);
        this._blueSpotlightModel = new Spotlight();
        this._blueSpotlightModel.setColor(VisibleColor.BLUE);
        this._blueSpotlightModel.setIntensity(0.0);
        this._blueSpotlightModel.setLocation(120.0, 545.0);
        this._blueSpotlightModel.setDirection(-27.0);
        this._redPhotonBeamModel = new PhotonBeam(this._redSpotlightModel);
        this._redPhotonBeamModel.setMaxPhotons(15);
        this._redPhotonBeamModel.setBounds(BEAM_BOUNDS);
        baseModel.addModelElement(this._redPhotonBeamModel);
        this._greenPhotonBeamModel = new PhotonBeam(this._greenSpotlightModel);
        this._greenPhotonBeamModel.setMaxPhotons(15);
        this._greenPhotonBeamModel.setBounds(BEAM_BOUNDS);
        baseModel.addModelElement(this._greenPhotonBeamModel);
        this._bluePhotonBeamModel = new PhotonBeam(this._blueSpotlightModel);
        this._bluePhotonBeamModel.setMaxPhotons(15);
        this._bluePhotonBeamModel.setBounds(BEAM_BOUNDS);
        baseModel.addModelElement(this._bluePhotonBeamModel);
        this.setControlPanel(new RgbBulbsControlPanel());
        ApparatusPanel3 apparatusPanel3 = new ApparatusPanel3(this.getClock(), 858, 630);
        apparatusPanel3.setBackground(APPARATUS_BACKGROUND);
        this.setApparatusPanel(apparatusPanel3);
        PersonGraphic personGraphic = new PersonGraphic(apparatusPanel3, 1.0, 8.0, this._personModel);
        SpotlightGraphic spotlightGraphic = new SpotlightGraphic(apparatusPanel3, this._redSpotlightModel);
        apparatusPanel3.addGraphic(spotlightGraphic, 5.0);
        SpotlightGraphic spotlightGraphic2 = new SpotlightGraphic(apparatusPanel3, this._greenSpotlightModel);
        apparatusPanel3.addGraphic(spotlightGraphic2, 6.0);
        SpotlightGraphic spotlightGraphic3 = new SpotlightGraphic(apparatusPanel3, this._blueSpotlightModel);
        apparatusPanel3.addGraphic(spotlightGraphic3, 7.0);
        PhotonBeamGraphic photonBeamGraphic = new PhotonBeamGraphic(apparatusPanel3, this._redPhotonBeamModel);
        apparatusPanel3.addGraphic(photonBeamGraphic, 2.0);
        PhotonBeamGraphic photonBeamGraphic2 = new PhotonBeamGraphic(apparatusPanel3, this._greenPhotonBeamModel);
        apparatusPanel3.addGraphic(photonBeamGraphic2, 3.0);
        PhotonBeamGraphic photonBeamGraphic3 = new PhotonBeamGraphic(apparatusPanel3, this._bluePhotonBeamModel);
        apparatusPanel3.addGraphic(photonBeamGraphic3, 4.0);
        this._redSlider = new ColorIntensitySlider(apparatusPanel3, VisibleColor.RED, INTENSITY_SLIDER_SIZE);
        this._redSlider.setLocation(RED_SLIDER_LOCATION);
        apparatusPanel3.addGraphic(this._redSlider, 5.0);
        this._greenSlider = new ColorIntensitySlider(apparatusPanel3, VisibleColor.GREEN, INTENSITY_SLIDER_SIZE);
        this._greenSlider.setLocation(GREEN_SLIDER_LOCATION);
        apparatusPanel3.addGraphic(this._greenSlider, 6.0);
        this._blueSlider = new ColorIntensitySlider(apparatusPanel3, VisibleColor.BLUE, INTENSITY_SLIDER_SIZE);
        this._blueSlider.setLocation(BLUE_SLIDER_LOCATION);
        apparatusPanel3.addGraphic(this._blueSlider, 7.0);
        this._personModel.addObserver(personGraphic);
        this._redSpotlightModel.addObserver(spotlightGraphic);
        this._redSpotlightModel.addObserver(this._redPhotonBeamModel);
        this._greenSpotlightModel.addObserver(spotlightGraphic2);
        this._greenSpotlightModel.addObserver(this._greenPhotonBeamModel);
        this._blueSpotlightModel.addObserver(spotlightGraphic3);
        this._blueSpotlightModel.addObserver(this._bluePhotonBeamModel);
        this._redPhotonBeamModel.addObserver(photonBeamGraphic);
        this._greenPhotonBeamModel.addObserver(photonBeamGraphic2);
        this._bluePhotonBeamModel.addObserver(photonBeamGraphic3);
        this._redPhotonBeamModel.addColorChangeListener(this);
        this._greenPhotonBeamModel.addColorChangeListener(this);
        this._bluePhotonBeamModel.addColorChangeListener(this);
        this._redSlider.addChangeListener(this);
        this._greenSlider.addChangeListener(this);
        this._blueSlider.addChangeListener(this);
        this._wiggleMe = new IntensitySliderWiggleMe(apparatusPanel3, baseModel);
        this._wiggleMe.setLocation(WIGGLE_ME_LOCATION);
        this._wiggleMe.start();
        apparatusPanel3.addGraphic(this._wiggleMe, 9.0);
        super.setHelpEnabled(false);
    }

    public void colorChanged(VisibleColorChangeEvent visibleColorChangeEvent) {
        int n = (int)(this._redPhotonBeamModel.getPerceivedIntensity() / 100.0 * 255.0);
        int n2 = (int)(this._greenPhotonBeamModel.getPerceivedIntensity() / 100.0 * 255.0);
        int n3 = (int)(this._bluePhotonBeamModel.getPerceivedIntensity() / 100.0 * 255.0);
        int n4 = 255;
        VisibleColor visibleColor = new VisibleColor(n, n2, n3, n4);
        this._personModel.setColor(visibleColor);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this._wiggleMe.isRunning()) {
            this._wiggleMe.stop();
            this._wiggleMe.setVisible(false);
        }
        if (changeEvent.getSource() == this._redSlider) {
            this._redSpotlightModel.setIntensity(this._redSlider.getValue());
        } else if (changeEvent.getSource() == this._greenSlider) {
            this._greenSpotlightModel.setIntensity(this._greenSlider.getValue());
        } else if (changeEvent.getSource() == this._blueSlider) {
            this._blueSpotlightModel.setIntensity(this._blueSlider.getValue());
        } else {
            throw new IllegalArgumentException("unexpected ChangeEvent from " + changeEvent.getSource());
        }
    }
}

