/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.view;

import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetTextGraphic2;
import edu.colorado.phet.faraday.model.PickupCoil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.DecimalFormat;

public class FluxDisplayGraphic
extends GraphicLayerSet
implements SimpleObserver {
    private static final Font FONT = new PhetFont(15);
    private static final DecimalFormat FORMAT = new DefaultDecimalFormat("0");
    private PickupCoil _pickupCoilModel;
    private PhetTextGraphic2 _averageBxValue;
    private PhetTextGraphic2 _fluxValue;
    private PhetTextGraphic2 _deltaFluxValue;
    private PhetTextGraphic2 _emfValue;

    public FluxDisplayGraphic(Component component, PickupCoil pickupCoil) {
        this._pickupCoilModel = pickupCoil;
        this._pickupCoilModel.addObserver(this);
        this._averageBxValue = new PhetTextGraphic2(component, FONT, "?", Color.YELLOW, 0, 0);
        this._fluxValue = new PhetTextGraphic2(component, FONT, "?", Color.YELLOW, 0, 25);
        this._deltaFluxValue = new PhetTextGraphic2(component, FONT, "?", Color.YELLOW, 0, 50);
        this._emfValue = new PhetTextGraphic2(component, FONT, "?", Color.YELLOW, 0, 75);
        this.addGraphic(this._averageBxValue);
        this.addGraphic(this._fluxValue);
        this.addGraphic(this._deltaFluxValue);
        this.addGraphic(this._emfValue);
        this.update();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.update();
        }
    }

    public void update() {
        if (this.isVisible()) {
            double d = this._pickupCoilModel.getAverageBx();
            double d2 = this._pickupCoilModel.getFlux();
            double d3 = this._pickupCoilModel.getDeltaFlux();
            double d4 = this._pickupCoilModel.getEmf();
            this._averageBxValue.setText("avg Bx = " + FORMAT.format(d) + "G");
            this._fluxValue.setText("\u03a6 = " + FORMAT.format(d2) + " W");
            this._deltaFluxValue.setText("\u0394\u03a6 = " + FORMAT.format(d3) + " W");
            this._emfValue.setText("EMF = " + FORMAT.format(d4) + " V");
        }
    }
}

