/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.model;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.faraday.model.AbstractCurrentSource;
import edu.colorado.phet.faraday.model.CoilMagnet;
import edu.colorado.phet.faraday.model.SourceCoil;

public class Electromagnet
extends CoilMagnet
implements SimpleObserver {
    private SourceCoil _sourceCoilModel;
    private AbstractCurrentSource _currentSource;
    private boolean _isFlipped;

    public Electromagnet(SourceCoil sourceCoil, AbstractCurrentSource abstractCurrentSource) {
        assert (sourceCoil != null);
        assert (abstractCurrentSource != null);
        this._sourceCoilModel = sourceCoil;
        this._sourceCoilModel.addObserver(this);
        this._currentSource = abstractCurrentSource;
        this._currentSource.addObserver(this);
        this._isFlipped = false;
        this.update();
    }

    public void setCurrentSource(AbstractCurrentSource abstractCurrentSource) {
        assert (abstractCurrentSource != null);
        if (abstractCurrentSource != this._currentSource) {
            if (this._currentSource != null) {
                this._currentSource.removeObserver(this);
            }
            this._currentSource = abstractCurrentSource;
            this._currentSource.addObserver(this);
            this.update();
        }
    }

    public void update() {
        double d = 2.0 * this._sourceCoilModel.getRadius() + this._sourceCoilModel.getWireWidth() / 2.0;
        super.setSize(d, d);
        this._sourceCoilModel.setCurrentAmplitude(this._currentSource.getAmplitude());
        double d2 = (double)this._sourceCoilModel.getNumberOfLoops() / 4.0 * this._currentSource.getAmplitude();
        d2 = MathUtil.clamp(-1.0, d2, 1.0);
        if (d2 >= 0.0 && this._isFlipped) {
            this.flipPolarity();
            this._isFlipped = false;
        } else if (d2 < 0.0 && !this._isFlipped) {
            this.flipPolarity();
            this._isFlipped = true;
        }
        double d3 = Math.abs(d2) * this.getMaxStrength();
        this.setStrength(d3);
    }
}

