/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.model;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.faraday.model.FaradayObservable;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public abstract class AbstractMagnet
extends FaradayObservable {
    private double _width = 250.0;
    private double _height = 50.0;
    private double _strength = 1.0;
    private double _maxStrength = Double.POSITIVE_INFINITY;
    private double _minStrength = 0.0;
    private AffineTransform _transform = new AffineTransform();
    private Point2D _relativePoint = new Point2D.Double();

    public void flipPolarity() {
        this.setDirection((this.getDirection() + Math.PI) % (Math.PI * 2));
    }

    public void setMaxStrength(double d) {
        if (d != this._maxStrength) {
            this._maxStrength = d;
            if (this._strength > this._maxStrength) {
                this._strength = this._maxStrength;
            }
            if (this._maxStrength < this._minStrength) {
                this._minStrength = this._maxStrength;
            }
            this.notifySelf();
            this.notifyObservers();
        }
    }

    public double getMaxStrength() {
        return this._maxStrength;
    }

    public void setMinStrength(double d) {
        if (d != this._minStrength) {
            this._minStrength = d;
            if (this._strength < this._minStrength) {
                this._strength = this._minStrength;
            }
            if (this._minStrength > this._maxStrength) {
                this._maxStrength = this._minStrength;
            }
            this.notifySelf();
            this.notifyObservers();
        }
    }

    public void setStrength(double d) {
        if (d < this._minStrength || d > this._maxStrength) {
            throw new IllegalArgumentException("strength out of range: " + d);
        }
        if (d != this._strength) {
            this._strength = d;
            this.notifySelf();
            this.notifyObservers();
        }
    }

    public double getStrength() {
        return this._strength;
    }

    public Vector2D getBField(Point2D point2D) {
        return this.getBField(point2D, new Vector2D());
    }

    public Vector2D getBField(Point2D point2D, Vector2D vector2D) {
        assert (point2D != null);
        assert (vector2D != null);
        this._transform.setToIdentity();
        this._transform.translate(-this.getX(), -this.getY());
        this._transform.rotate(-this.getDirection(), this.getX(), this.getY());
        this._transform.transform(point2D, this._relativePoint);
        this.getBFieldRelative(this._relativePoint, vector2D);
        vector2D.rotate(this.getDirection());
        double d = this.getStrength();
        double d2 = vector2D.getMagnitude();
        if (d2 > d) {
            vector2D.setMagnitude(d);
        }
        return vector2D;
    }

    protected abstract Vector2D getBFieldRelative(Point2D var1, Vector2D var2);

    public void setSize(double d, double d2) {
        if (d <= 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException("dimensions must be > 0");
        }
        if (d != this._width || d2 != this._height) {
            this._width = d;
            this._height = d2;
            this.notifySelf();
            this.notifyObservers();
        }
    }

    public double getWidth() {
        return this._width;
    }

    public double getHeight() {
        return this._height;
    }
}

