/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.faraday.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.faraday.model.AbstractCurrentSource;

public class ACPowerSupply
extends AbstractCurrentSource
implements ModelElement {
    private double _maxAmplitude = 1.0;
    private double _frequency = 1.0;
    private double _angle = 0.0;
    private double _deltaAngle = Math.PI * 2 * this._frequency / 10.0;
    private double _stepAngle = 0.0;

    public void setMaxAmplitude(double d) {
        assert (d >= 0.0 && d <= 1.0);
        if (d != this._maxAmplitude) {
            this._maxAmplitude = d;
            this._angle = 0.0;
            this.notifyObservers();
        }
    }

    public double getMaxAmplitude() {
        return this._maxAmplitude;
    }

    public void setFrequency(double d) {
        assert (d >= 0.0 && d <= 1.0);
        if (d != this._frequency) {
            this._frequency = d;
            this._angle = 0.0;
            this._deltaAngle = Math.PI * 2 * this._frequency / 10.0;
            this.notifyObservers();
        }
    }

    public double getFrequency() {
        return this._frequency;
    }

    public double getStepAngle() {
        return this._stepAngle;
    }

    public void stepInTime(double d) {
        if (this.isEnabled()) {
            if (this._maxAmplitude == 0.0) {
                this.setAmplitude(0.0);
            } else {
                double d2 = this._angle;
                this._angle += d * this._deltaAngle;
                this._stepAngle = this._angle - d2;
                if (this._angle >= Math.PI * 2) {
                    this._angle %= Math.PI * 2;
                }
                this.setAmplitude(this._maxAmplitude * Math.sin(this._angle));
            }
        }
    }
}

