/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.CCKSimulationPanel;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;

public class CCKBackground
extends PNode {
    private CCKModel model;
    private CCKSimulationPanel cckSimulationPanel;
    private PPath path;
    private Color color = CCKModule.BACKGROUND_COLOR;

    public CCKBackground(final CCKModel cCKModel, CCKSimulationPanel cCKSimulationPanel) {
        this.model = cCKModel;
        this.cckSimulationPanel = cCKSimulationPanel;
        this.path = new PhetPPath(this.color);
        this.addChild(this.path);
        cCKSimulationPanel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                CCKBackground.this.update();
            }

            public void componentShown(ComponentEvent componentEvent) {
                CCKBackground.this.update();
            }
        });
        this.update();
        this.addInputEventListener(new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent pInputEvent) {
                cCKModel.clearSelection();
            }
        });
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.path.setPaint(color);
    }

    private void update() {
        this.path.setPathToRectangle(0.0f, 0.0f, this.cckSimulationPanel.getWidth(), this.cckSimulationPanel.getHeight());
    }
}

