/*
 * Decompiled with CFR 0.152.
 */
package org.cove.jade;

import java.util.Vector;
import org.cove.jade.constraints.Constraint;
import org.cove.jade.primitives.Particle;
import org.cove.jade.surfaces.Surface;
import org.cove.jade.util.GVector;

public class DynamicsEngine {
    public GVector gravity;
    public double coeffRest = 1.5;
    public double coeffFric = 0.01;
    public double coeffDamp = 0.99;
    public Vector primitives = new Vector();
    public Vector surfaces = new Vector();
    public Vector constraints = new Vector();
    private double dt = 1.0;

    public DynamicsEngine() {
        this.gravity = new GVector(0.0, 1.0);
    }

    public void addPrimitive(Particle particle) {
        this.primitives.add(particle);
    }

    public void removePrimitive(Particle particle) {
        this.primitives.remove(particle);
    }

    public void addSurface(Surface surface) {
        this.surfaces.add(surface);
    }

    public void timeStep() {
        this.verlet();
        this.satisfyConstraints();
        this.checkCollisions();
    }

    public void setSurfaceBounce(double d) {
        this.coeffRest = 1.0 + d;
    }

    public void setDamping(double d) {
        this.coeffDamp = d;
    }

    public void setGravity(double d, double d2) {
        this.gravity.x = d;
        this.gravity.y = d2;
    }

    private void verlet() {
        for (int i = 0; i < this.primitives.size(); ++i) {
            ((Particle)this.primitives.elementAt(i)).verlet(this);
        }
    }

    private void satisfyConstraints() {
        for (int i = 0; i < this.constraints.size(); ++i) {
            ((Constraint)this.constraints.elementAt(i)).resolve();
        }
    }

    private void checkCollisions() {
        for (int i = 0; i < this.surfaces.size(); ++i) {
            Surface surface = (Surface)this.surfaces.elementAt(i);
            if (!surface.getActiveState()) continue;
            for (int j = 0; j < this.primitives.size(); ++j) {
                ((Particle)this.primitives.elementAt(j)).checkCollision(surface, this);
            }
        }
    }
}

