/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.travoltage;

import edu.colorado.phet.common.piccolophet.util.PImageFactory;
import edu.colorado.phet.travoltage.ArmNode;
import edu.colorado.phet.travoltage.DefaultLocationMap;
import edu.colorado.phet.travoltage.DoorknobNode;
import edu.colorado.phet.travoltage.ElectronSetNode;
import edu.colorado.phet.travoltage.JadeElectron;
import edu.colorado.phet.travoltage.JadeElectronNode;
import edu.colorado.phet.travoltage.LegNode;
import edu.colorado.phet.travoltage.LimbLocationMap;
import edu.colorado.phet.travoltage.LimbNode;
import edu.colorado.phet.travoltage.SparkNode;
import edu.colorado.phet.travoltage.TravoltageBackgroundNode;
import edu.colorado.phet.travoltage.TravoltageBodyNode;
import edu.colorado.phet.travoltage.TravoltageModel;
import edu.colorado.phet.travoltage.TravoltageModule;
import edu.colorado.phet.travoltage.TravoltagePanel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.geom.Point2D;

public class TravoltageRootNode
extends PNode {
    private TravoltageBodyNode travoltageBodyNode;
    private ElectronSetNode electronSetNode;
    private TravoltageModule travoltageModule;
    private DoorknobNode doorknobNode;
    private SparkNode sparkNode;
    private TravoltageBackgroundNode backgroundNode;

    public TravoltageRootNode(TravoltageModule travoltageModule, TravoltagePanel travoltagePanel, TravoltageModel travoltageModel) {
        this.travoltageModule = travoltageModule;
        this.travoltageBodyNode = new TravoltageBodyNode();
        Point2D.Double double_ = new Point2D.Double(300.0, 75.0);
        this.backgroundNode = new TravoltageBackgroundNode();
        this.backgroundNode.setOffset(-((Point2D)double_).getX(), -((Point2D)double_).getY());
        this.addChild(this.backgroundNode);
        PImage pImage = PImageFactory.create("travoltage/images/door.gif");
        pImage.scale(0.75);
        this.addChild(pImage);
        pImage.setOffset(290.0, -42.0);
        this.doorknobNode = new DoorknobNode();
        this.doorknobNode.setOffset(300.0, 112.0);
        this.addChild(this.doorknobNode);
        this.addChild(this.travoltageBodyNode);
        this.electronSetNode = new ElectronSetNode(travoltageModel.getJadeElectronSet());
        this.addChild(this.electronSetNode);
        LimbNode.Listener listener = new LimbNode.Listener(){

            public void limbRotated() {
                TravoltageRootNode.this.remapLocations();
            }
        };
        this.getLegNode().addListener(listener);
        this.getArmNode().addListener(listener);
        this.getArmNode().setAngle(-0.95);
        double d = 0.8267349088394192;
        this.sparkNode = new SparkNode(this.getArmNode(), this.getDoorknobNode(), d, 4.0, 6.0, travoltageModule.getClock());
        travoltageModel.addListener(new TravoltageModel.Listener(){

            public void sparkStarted() {
            }

            public void sparkFinished() {
                TravoltageRootNode.this.sparkNode.setVisible(false);
            }

            public void electronExitedFinger() {
                TravoltageRootNode.this.sparkNode.setVisible(true);
            }
        });
        this.addChild(this.sparkNode);
        this.setSparkVisible(false);
        this.setOffset(double_);
    }

    public TravoltageBodyNode getTravoltageBodyNode() {
        return this.travoltageBodyNode;
    }

    public void pickUpElectron() {
        Point2D point2D = this.getElectronEntryPoint();
        JadeElectron jadeElectron = new JadeElectron(point2D.getX(), point2D.getY(), JadeElectronNode.getViewRadius());
        JadeElectronNode jadeElectronNode = new JadeElectronNode(this.getTravoltageBodyNode(), jadeElectron);
        jadeElectronNode.setLocationMap(new LimbLocationMap(this.getLegNode(), this.getArmNode(), new DefaultLocationMap(jadeElectronNode.getRadius()), this.getTravoltageBodyNode()));
        this.travoltageModule.addElectron(jadeElectron);
        this.electronSetNode.addElectronNode(jadeElectronNode);
    }

    private ArmNode getArmNode() {
        return this.travoltageBodyNode.getArmNode();
    }

    private Point2D getElectronEntryPoint() {
        return this.getLegNode().getGlobalElectronEntryPoint();
    }

    private LegNode getLegNode() {
        return this.travoltageBodyNode.getLegNode();
    }

    private void remapLocations() {
        for (int i = 0; i < this.electronSetNode.getNumElectrons(); ++i) {
            this.electronSetNode.getElectronNode(i).update();
        }
    }

    public DoorknobNode getDoorknobNode() {
        return this.doorknobNode;
    }

    public void setSparkVisible(boolean bl) {
        this.sparkNode.setVisible(bl);
    }
}

