/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.travoltage;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.travoltage.JadeElectron;
import edu.colorado.phet.travoltage.JadeElectronSet;
import edu.colorado.phet.travoltage.MoveElectronsJade;
import edu.colorado.phet.travoltage.TravoltageModule;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class MoveToFinger
extends MoveElectronsJade {
    private TravoltageModule module;
    private Line2D.Double[] segments;
    private JadeElectronSet jadeElectronSet;
    String str = "265, 348, 220, 377\n220, 377, 151, 244\n151, 244, 118, 142\n118, 142, 207, 161\n207, 161, 291, 133\n200, 24, 120, 88\n190, 66, 144, 65\n82, 67, 132, 131\n40, 135, 130, 138\n15, 209, 134, 150\n66, 236, 131, 153\n116, 396, 58, 386\n57, 387, 103, 281\n103, 281, 115, 151\n180, 109, 153, 151\n182, 130, 174, 156\n160, 155, 231, 155\n231, 155, 295, 133";

    public MoveToFinger(TravoltageModule travoltageModule, JadeElectronSet jadeElectronSet) {
        super(jadeElectronSet);
        this.jadeElectronSet = jadeElectronSet;
        this.module = travoltageModule;
        this.segments = this.getSegments();
        this.getEngine().setDamping(0.93);
        this.getEngine().setSurfaceBounce(0.6);
    }

    private Line2D.Double[] getSegments() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.str, "\n, ");
        ArrayList<Line2D.Double> arrayList = new ArrayList<Line2D.Double>();
        while (stringTokenizer.hasMoreTokens()) {
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = Integer.parseInt(stringTokenizer.nextToken());
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            arrayList.add(new Line2D.Double(n, n2, n3, n4));
        }
        return arrayList.toArray(new Line2D.Double[0]);
    }

    protected ImmutableVector2D getForce(JadeElectron jadeElectron) {
        Line2D.Double double_ = this.getClosestSegment(jadeElectron.getPosition().getX(), jadeElectron.getPosition().getY());
        Vector2D vector2D = new Vector2D(jadeElectron.getPosition(), double_.getP2());
        double d = 30.0;
        ImmutableVector2D immutableVector2D = vector2D.getInstanceOfMagnitude(d / Math.pow(vector2D.getMagnitude(), 1.0));
        double d2 = 10.0;
        if (immutableVector2D.getMagnitude() > d2) {
            immutableVector2D = immutableVector2D.getInstanceOfMagnitude(d2);
        }
        return immutableVector2D;
    }

    private Line2D.Double getClosestSegment(double d, double d2) {
        Line2D.Double double_ = null;
        double d3 = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.segments.length; ++i) {
            double d4 = new Point2D.Double(this.segments[i].getX1(), this.segments[i].getY1()).distance(d, d2);
            if (!(d4 < d3)) continue;
            double_ = this.segments[i];
            d3 = d4;
        }
        return double_;
    }

    public void stepInTime(double d) {
        super.stepInTime(d);
        super.stepInTime(d);
        super.stepInTime(d);
        for (int i = 0; i < this.jadeElectronSet.getNumElectrons(); ++i) {
            JadeElectron jadeElectron = this.jadeElectronSet.getJadeElectron(i);
            double d2 = 30.0;
            double d3 = jadeElectron.getPosition().distance(this.getFingerLocation());
            if (!(d3 < d2)) continue;
            this.jadeElectronSet.removeElectron(i);
            this.module.getTravoltageModel().notifyElectronsExiting();
            --i;
        }
        if (this.jadeElectronSet.getNumElectrons() == 0) {
            this.module.getTravoltageModel().finishSpark();
        }
    }

    private Point2D getFingerLocation() {
        Point2D point2D = this.module.getTravoltagePanel().getTravoltageRootNode().getTravoltageBodyNode().getArmNode().getGlobalFingertipPointWithoutRotation();
        point2D = this.module.getTravoltagePanel().getTravoltageRootNode().getTravoltageBodyNode().globalToLocal(point2D);
        return point2D;
    }
}

