/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.travoltage;

import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.common.piccolophet.util.PImageFactory;
import edu.colorado.phet.travoltage.DefaultLocationMap;
import edu.colorado.phet.travoltage.JadeElectron;
import edu.colorado.phet.travoltage.LocationMap;
import edu.colorado.phet.travoltage.TravoltageBodyNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.geom.Point2D;
import java.io.IOException;

public class JadeElectronNode
extends PNode {
    private TravoltageBodyNode travoltageBodyNode;
    private JadeElectron electron;
    private LocationMap locationMap = new DefaultLocationMap(this.getRadius());

    public static double getViewRadius() {
        try {
            return ImageLoader.loadBufferedImage("travoltage/images/Electron3.GIF").getWidth() / 2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return Double.NaN;
        }
    }

    public JadeElectronNode(TravoltageBodyNode travoltageBodyNode, JadeElectron jadeElectron) {
        this.travoltageBodyNode = travoltageBodyNode;
        this.electron = jadeElectron;
        this.addChild(PImageFactory.create("travoltage/images/Electron3.GIF"));
        this.setPickable(false);
        this.setChildrenPickable(false);
        this.update();
        jadeElectron.addListener(new JadeElectron.Listener(){

            public void electronMoved() {
                JadeElectronNode.this.update();
            }
        });
    }

    public void update() {
        Point2D point2D = this.locationMap.getLocation(this.electron.getPosition());
        this.setOffset(point2D.getX() + this.travoltageBodyNode.getOffset().getX(), point2D.getY() + this.travoltageBodyNode.getOffset().getY());
    }

    public double getRadius() {
        return this.getFullBounds().getWidth() / 2.0;
    }

    public JadeElectron getJadeElectron() {
        return this.electron;
    }

    public void setLocationMap(LocationMap locationMap) {
        this.locationMap = locationMap;
        this.update();
    }
}

